/*
 * Decompiled with CFR 0.152.
 */
package org.enhydra.jdbc.standard;

import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.sql.ConnectionPoolDataSource;
import javax.sql.PooledConnection;
import org.enhydra.jdbc.standard.StandardDataSource;
import org.enhydra.jdbc.standard.StandardPooledConnection;
import org.enhydra.jdbc.util.LRUCache;

public class StandardConnectionPoolDataSource
extends StandardDataSource
implements ConnectionPoolDataSource {
    private Hashtable masterPrepStmtCache = new Hashtable();
    int preparedStmtCacheSize = 16;
    public static final int DEFAULT_PREPAREDSTMTCACHESIZE = 16;

    public PooledConnection getPooledConnection() throws SQLException {
        this.log.debug("StandardConnectionPoolDataSource:getPooledConnection(0) return a pooled connection");
        return this.getPooledConnection(this.user, this.password);
    }

    public synchronized PooledConnection getPooledConnection(String user, String password) throws SQLException {
        this.log.debug("StandardConnectionPoolDataSource:getPooledConnection(2) return a pooled connection");
        return new StandardPooledConnection(this, user, password);
    }

    public Hashtable getMasterPrepStmtCache() {
        return this.masterPrepStmtCache;
    }

    public int getPreparedStmtCacheSize() {
        return this.preparedStmtCacheSize;
    }

    public void setPreparedStmtCacheSize(int value) {
        this.preparedStmtCacheSize = value;
        if (this.preparedStmtCacheSize <= 0) {
            this.masterPrepStmtCache.clear();
        } else {
            Enumeration enumeration = this.masterPrepStmtCache.elements();
            while (enumeration.hasMoreElements()) {
                ((LRUCache)enumeration.nextElement()).resize(value);
            }
        }
    }
}

