/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.carol.jndi.iiop;

import java.util.Hashtable;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NameParser;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.Referenceable;
import javax.naming.spi.ObjectFactory;
import org.objectweb.carol.jndi.iiop.IIOPRemoteReference;
import org.objectweb.carol.jndi.iiop.IIOPRemoteResource;
import org.objectweb.carol.util.configuration.TraceCarol;

public class IIOPContextWrapper
implements Context {
    private static Context iiopContext = null;

    public IIOPContextWrapper(Context iiopCtx) throws NamingException {
        iiopContext = iiopCtx;
    }

    private Object resolveObject(Object o) {
        try {
            if (o instanceof IIOPRemoteReference) {
                Reference objRef = ((IIOPRemoteReference)o).getReference();
                ObjectFactory objFact = (ObjectFactory)Class.forName(objRef.getFactoryClassName()).newInstance();
                return (Referenceable)objFact.getObjectInstance(objRef, null, null, null);
            }
            if (o instanceof IIOPRemoteResource) {
                return ((IIOPRemoteResource)o).getResource();
            }
            return o;
        }
        catch (Exception e) {
            TraceCarol.error("IIOPContextWrapper.resolveObject()", e);
            return o;
        }
    }

    public Object lookup(String name) throws NamingException {
        return this.resolveObject(iiopContext.lookup(name));
    }

    public Object lookup(Name name) throws NamingException {
        return this.resolveObject(iiopContext.lookup(name));
    }

    public void bind(String name, Object obj) throws NamingException {
        iiopContext.bind(name, obj);
    }

    public void bind(Name name, Object obj) throws NamingException {
        iiopContext.bind(name, obj);
    }

    public void rebind(String name, Object obj) throws NamingException {
        iiopContext.rebind(name, obj);
    }

    public void rebind(Name name, Object obj) throws NamingException {
        iiopContext.rebind(name, obj);
    }

    public void unbind(String name) throws NamingException {
        iiopContext.unbind(name);
    }

    public void unbind(Name name) throws NamingException {
        iiopContext.unbind(name);
    }

    public void rename(String oldName, String newName) throws NamingException {
        iiopContext.rename(oldName, newName);
    }

    public void rename(Name oldName, Name newName) throws NamingException {
        iiopContext.rename(oldName, newName);
    }

    public NamingEnumeration list(String name) throws NamingException {
        return iiopContext.list(name);
    }

    public NamingEnumeration list(Name name) throws NamingException {
        return iiopContext.list(name);
    }

    public NamingEnumeration listBindings(String name) throws NamingException {
        return iiopContext.listBindings(name);
    }

    public NamingEnumeration listBindings(Name name) throws NamingException {
        return iiopContext.listBindings(name);
    }

    public void destroySubcontext(String name) throws NamingException {
        iiopContext.destroySubcontext(name);
    }

    public void destroySubcontext(Name name) throws NamingException {
        iiopContext.destroySubcontext(name);
    }

    public Context createSubcontext(String name) throws NamingException {
        return iiopContext.createSubcontext(name);
    }

    public Context createSubcontext(Name name) throws NamingException {
        return iiopContext.createSubcontext(name);
    }

    public Object lookupLink(String name) throws NamingException {
        return iiopContext.lookupLink(name);
    }

    public Object lookupLink(Name name) throws NamingException {
        return iiopContext.lookupLink(name);
    }

    public NameParser getNameParser(String name) throws NamingException {
        return iiopContext.getNameParser(name);
    }

    public NameParser getNameParser(Name name) throws NamingException {
        return iiopContext.getNameParser(name);
    }

    public String composeName(String name, String prefix) throws NamingException {
        return name;
    }

    public Name composeName(Name name, Name prefix) throws NamingException {
        return (Name)name.clone();
    }

    public Object addToEnvironment(String propName, Object propVal) throws NamingException {
        return iiopContext.addToEnvironment(propName, propVal);
    }

    public Object removeFromEnvironment(String propName) throws NamingException {
        return iiopContext.removeFromEnvironment(propName);
    }

    public Hashtable getEnvironment() throws NamingException {
        return iiopContext.getEnvironment();
    }

    public void close() throws NamingException {
        iiopContext.close();
    }

    public String getNameInNamespace() throws NamingException {
        return iiopContext.getNameInNamespace();
    }
}

