/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.configurator.ssl;

import com.atlassian.jira.config.properties.JiraSystemProperties;
import java.security.cert.X509Certificate;
import java.text.DateFormat;
import javax.annotation.Nonnull;

public class CertificatePrettyPrinter {
    private static final String NEWLINE = JiraSystemProperties.getInstance().getProperty("line.separator");

    @Nonnull
    public static String prettyPrint(@Nonnull X509Certificate cert) {
        DateFormat dateFormater = DateFormat.getDateInstance(0);
        StringBuilder builder = new StringBuilder();
        builder.append("SerialNumber: ").append(cert.getSerialNumber()).append(NEWLINE).append("IssuerDN: ").append(cert.getIssuerDN().getName()).append(NEWLINE).append("Start Date: ").append(dateFormater.format(cert.getNotBefore())).append(NEWLINE).append("Final Date: ").append(dateFormater.format(cert.getNotAfter())).append(NEWLINE).append("SubjectDN: ").append(cert.getSubjectDN().getName()).append(NEWLINE);
        return builder.toString();
    }
}

