/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.configurator.gui;

import com.atlassian.jira.cluster.ClusterSafe;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.ScrollPane;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JTextArea;

public class ConnectionTestDialog
extends JDialog {
    private JButton btnOK;
    private boolean active;
    private JTextArea textArea = new JTextArea();

    public ConnectionTestDialog(JFrame parent) {
        super((Frame)parent, "DB Connection Test");
        this.init(parent);
    }

    @ClusterSafe(value="This is not part of the JIRA web app.")
    public synchronized void setActive(boolean active) {
        this.active = active;
    }

    @ClusterSafe(value="This is not part of the JIRA web app.")
    public synchronized void showIfActive() {
        if (this.active) {
            this.setVisible(true);
        } else {
            this.setVisible(true);
        }
    }

    private void init(JFrame parent) {
        this.setModal(true);
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                if (ConnectionTestDialog.this.btnOK.isEnabled()) {
                    ConnectionTestDialog.this.setVisible(false);
                }
            }
        });
        this.setSize(parent.getWidth() - 50, 200);
        this.setLayout(new BorderLayout());
        this.textArea.setEditable(false);
        ScrollPane scrollPane = new ScrollPane();
        scrollPane.add(this.textArea);
        this.add((Component)scrollPane, "Center");
        this.add((Component)this.newButtonPanel(), "South");
        this.setLocationRelativeTo(parent);
    }

    private JPanel newButtonPanel() {
        JPanel panel = new JPanel();
        this.btnOK = new JButton("OK");
        this.btnOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ConnectionTestDialog.this.setVisible(false);
            }
        });
        this.btnOK.setEnabled(false);
        panel.add(this.btnOK);
        return panel;
    }

    public void setText(String text) {
        this.textArea.setText(text);
    }

    public void addText(String text) {
        this.textArea.setText(this.textArea.getText() + "\n" + text);
    }

    public void enableCloseButton(boolean b) {
        this.btnOK.setEnabled(b);
    }
}

