/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.configurator.db;

import com.atlassian.jira.config.database.DatabaseType;
import com.atlassian.jira.config.database.jdbcurlparser.DatabaseInstance;
import com.atlassian.jira.configurator.db.CommonConfigPanel;
import com.atlassian.jira.configurator.gui.ConfigPanelBuilder;
import com.atlassian.jira.exception.ParseException;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class SqlServerConfigPanel
extends CommonConfigPanel {
    private JTextField tfDatabase = new JTextField(20);
    private JTextField tfSchemaName = new JTextField(20);

    public SqlServerConfigPanel() {
        super(DatabaseType.SQL_SERVER);
    }

    @Override
    public String getDisplayName() {
        return "SQL Server";
    }

    @Override
    protected JPanel buildConfigPanel() {
        ConfigPanelBuilder panelBuilder = new ConfigPanelBuilder();
        panelBuilder.add("Hostname", this.tfHostname);
        panelBuilder.add("Port", this.tfPort);
        panelBuilder.add("Database", this.tfDatabase);
        panelBuilder.add("Username", this.tfUsername);
        panelBuilder.add("Password", this.tfPassword);
        panelBuilder.add("Schema", this.tfSchemaName);
        this.tfPort.setText("1433");
        this.tfSchemaName.setText("dbo");
        this.tfDatabase.setToolTipText("The database instance to connect to");
        this.tfSchemaName.setToolTipText("Set an explicit schema, or leave blank to use the default schema for the database");
        return panelBuilder.getPanel();
    }

    @Override
    protected void setUrlSettings(DatabaseInstance connectionProperties) throws ParseException {
        this.tfHostname.setText(connectionProperties.getHostname());
        this.tfPort.setText(connectionProperties.getPort());
        this.tfDatabase.setText(connectionProperties.getInstance());
    }

    @Override
    public String getSchemaName() {
        return this.tfSchemaName.getText();
    }

    @Override
    protected void setSchemaName(String schemaName) {
        this.tfSchemaName.setText(schemaName);
    }

    @Override
    protected String getHostname() {
        return this.tfHostname.getText().trim();
    }

    @Override
    protected String getPort() {
        return this.tfPort.getText().trim();
    }

    @Override
    protected String getInstance() {
        return this.tfDatabase.getText().trim();
    }
}

