/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.configurator.db;

import com.atlassian.jira.config.database.DatabaseType;
import com.atlassian.jira.configurator.config.Settings;
import com.atlassian.jira.configurator.config.ValidationException;
import com.atlassian.jira.configurator.db.ConfigField;
import com.atlassian.jira.configurator.db.DatabaseConfigConsole;
import com.atlassian.jira.configurator.db.DatabaseConfigConsoleImpl;
import com.atlassian.jira.exception.ParseException;
import java.sql.SQLException;

public class PostgresConfigConsole
implements DatabaseConfigConsole {
    private ConfigField[] postgresFields;
    private final ConfigField schemaName = new ConfigField("Schema name");
    private final DatabaseConfigConsole coreCofiguration = new DatabaseConfigConsoleImpl(DatabaseType.POSTGRES);

    @Override
    public ConfigField[] getFields() {
        if (this.postgresFields == null) {
            ConfigField[] superFields = this.coreCofiguration.getFields();
            this.postgresFields = new ConfigField[superFields.length + 1];
            System.arraycopy(superFields, 0, this.postgresFields, 0, superFields.length);
            this.postgresFields[superFields.length] = this.schemaName;
        }
        return this.postgresFields;
    }

    @Override
    public void setSettings(Settings settings) throws ParseException {
        this.coreCofiguration.setSettings(settings);
        this.schemaName.setValue(settings.getSchemaName());
    }

    @Override
    public void saveSettings(Settings newSettings) throws ValidationException {
        this.coreCofiguration.saveSettings(newSettings);
        newSettings.setSchemaName(this.getSchemaName());
    }

    @Override
    public String getInstanceName() {
        return this.coreCofiguration.getInstanceName();
    }

    @Override
    public String getDatabaseType() {
        return this.coreCofiguration.getDatabaseType();
    }

    @Override
    public void testConnection() throws ClassNotFoundException, SQLException, ValidationException {
        this.coreCofiguration.testConnection();
    }

    @Override
    public String getUsername() {
        return this.coreCofiguration.getUsername();
    }

    @Override
    public String getPassword() {
        return this.coreCofiguration.getPassword();
    }

    @Override
    public String getUrl() throws ValidationException {
        return this.coreCofiguration.getUrl();
    }

    @Override
    public String getClassName() {
        return this.coreCofiguration.getClassName();
    }

    public String getSchemaName() {
        return this.schemaName.getValue();
    }
}

