/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.configurator.db;

import com.atlassian.jira.config.database.JdbcDatasource;
import com.atlassian.jira.configurator.config.Settings;
import com.atlassian.jira.configurator.config.ValidationException;
import com.atlassian.jira.configurator.db.DatabaseConfigPanel;
import com.atlassian.jira.configurator.gui.ConfigPanelBuilder;
import com.atlassian.jira.exception.ParseException;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;

public class MySqlConfigPanel
extends DatabaseConfigPanel {
    private JTextField tfHostname = new JTextField(20);
    private JTextField tfPort = new JTextField(20);
    private JTextField tfDatabase = new JTextField(20);
    private JTextField tfUsername = new JTextField(20);
    private JTextField tfPassword = new JPasswordField(20);
    private JPanel configPanel;

    @Override
    public String getDisplayName() {
        return "MySQL";
    }

    @Override
    public String getClassName() {
        return "com.mysql.jdbc.Driver";
    }

    @Override
    public String getUrl(String jiraHome) {
        String url = "jdbc:mysql://" + this.tfHostname.getText();
        if (this.tfPort.getText().trim().length() > 0) {
            url = url + ':' + this.tfPort.getText();
        }
        return url + "/" + this.tfDatabase.getText() + "?useUnicode=true&characterEncoding=UTF8&sessionVariables=default_storage_engine=InnoDB";
    }

    @Override
    public String getUsername() {
        return this.tfUsername.getText();
    }

    @Override
    public String getPassword() {
        return this.tfPassword.getText();
    }

    @Override
    public String getSchemaName() {
        return null;
    }

    @Override
    public JPanel getPanel() {
        if (this.configPanel == null) {
            ConfigPanelBuilder panelBuilder = new ConfigPanelBuilder();
            panelBuilder.add("Hostname", this.tfHostname);
            this.tfHostname.setToolTipText("The hostname or IP address of the MySQL server");
            panelBuilder.add("Port", this.tfPort);
            this.tfPort.setText("3306");
            this.tfPort.setToolTipText("The port number that MySQL is running on. Leave blank for default (3306)");
            panelBuilder.add("Database", this.tfDatabase);
            this.tfDatabase.setToolTipText("The database to connect to");
            panelBuilder.add("Username", this.tfUsername);
            this.tfUsername.setToolTipText("The username used to login");
            panelBuilder.add("Password", this.tfPassword);
            this.tfPassword.setToolTipText("The password used to login");
            this.configPanel = panelBuilder.getPanel();
        }
        return this.configPanel;
    }

    @Override
    public void setSettings(Settings settings) throws ParseException {
        JdbcDatasource.Builder datasourceBuilder = settings.getJdbcDatasourceBuilder();
        this.tfUsername.setText(datasourceBuilder.getUsername());
        this.tfPassword.setText(datasourceBuilder.getPassword());
        ConnectionProperties connectionProperties = this.parseUrl(datasourceBuilder.getJdbcUrl());
        this.tfHostname.setText(connectionProperties.host);
        this.tfPort.setText(connectionProperties.port);
        this.tfDatabase.setText(connectionProperties.database);
    }

    ConnectionProperties parseUrl(String jdbcUrl) throws ParseException {
        if (!jdbcUrl.startsWith("jdbc:mysql://")) {
            throw new ParseException("Unable to parse the MySQL JDBC URL '" + jdbcUrl + "'.");
        }
        String stripped = jdbcUrl.substring("jdbc:mysql://".length());
        String[] hostPort_DatabaseAndProperties = stripped.split("/", 2);
        ConnectionProperties connectionProperties = new ConnectionProperties();
        String[] hostPort = hostPort_DatabaseAndProperties[0].split(":", 2);
        connectionProperties.host = hostPort[0];
        connectionProperties.port = hostPort.length == 1 ? "" : hostPort[1];
        String[] database_Properties = hostPort_DatabaseAndProperties[1].split("\\?", 2);
        connectionProperties.database = database_Properties[0];
        connectionProperties.properties = database_Properties.length == 1 ? "" : database_Properties[1];
        return connectionProperties;
    }

    @Override
    public void validate() throws ValidationException {
        this.validatePortNumber(this.tfPort.getText());
        this.validateNotBlank("Database", this.tfDatabase.getText());
    }

    class ConnectionProperties {
        String host;
        String port;
        String database;
        String properties;

        ConnectionProperties() {
        }
    }
}

