/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.configurator.db;

import com.atlassian.jira.config.database.DatabaseType;
import com.atlassian.jira.config.database.JdbcDatasource;
import com.atlassian.jira.config.database.jdbcurlparser.DatabaseInstance;
import com.atlassian.jira.configurator.config.Settings;
import com.atlassian.jira.configurator.config.ValidationException;
import com.atlassian.jira.configurator.db.AbstractConnectionConfig;
import com.atlassian.jira.configurator.db.ConfigField;
import com.atlassian.jira.configurator.db.DatabaseConfigConsole;
import com.atlassian.jira.exception.ParseException;

public class DatabaseConfigConsoleImpl
extends AbstractConnectionConfig
implements DatabaseConfigConsole {
    private final ConfigField cfHostname = new ConfigField("Hostname");
    private final ConfigField cfPort = new ConfigField("Port");
    private final ConfigField cfInstance = new ConfigField("Instance");
    private final ConfigField cfUsername = new ConfigField("Username");
    private final ConfigField cfPassword = new ConfigField("Password", true);
    private ConfigField[] fields = new ConfigField[]{this.cfHostname, this.cfPort, this.cfInstance, this.cfUsername, this.cfPassword};
    private DatabaseType databaseType;

    public DatabaseConfigConsoleImpl(DatabaseType databaseType) {
        this.databaseType = databaseType;
        this.cfInstance.setLabel(databaseType.getInstanceFieldName());
    }

    @Override
    public String getDatabaseType() {
        return this.databaseType.getDisplayName();
    }

    @Override
    public ConfigField[] getFields() {
        return this.fields;
    }

    @Override
    public void setSettings(Settings settings) throws ParseException {
        JdbcDatasource.Builder datasourceBuilder = settings.getJdbcDatasourceBuilder();
        this.cfUsername.setValue(datasourceBuilder.getUsername());
        this.cfPassword.setValue(datasourceBuilder.getPassword());
        DatabaseInstance databaseInstance = this.databaseType.getJdbcUrlParser().parseUrl(datasourceBuilder.getJdbcUrl());
        this.cfHostname.setValue(databaseInstance.getHostname());
        this.cfPort.setValue(databaseInstance.getPort());
        this.cfInstance.setValue(databaseInstance.getInstance());
    }

    @Override
    public String getInstanceName() {
        return this.cfHostname.getValue() + ':' + this.cfPort.getValue() + '/' + this.cfInstance.getValue();
    }

    @Override
    public String getUsername() {
        return this.cfUsername.getValue();
    }

    @Override
    public String getPassword() {
        return this.cfPassword.getValue();
    }

    @Override
    public String getUrl() throws ValidationException {
        try {
            return this.databaseType.getJdbcUrlParser().getUrl(this.cfHostname.getValue(), this.cfPort.getValue(), this.cfInstance.getValue());
        }
        catch (ParseException e) {
            throw new ValidationException(e.getMessage());
        }
    }

    @Override
    public String getClassName() {
        return this.databaseType.getJdbcDriverClassName();
    }
}

