/*
 * Decompiled with CFR 0.152.
 */
package webwork.config;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import webwork.config.AbstractConfiguration;
import webwork.config.ConfigurationInterface;

public class DelegatingConfiguration
extends AbstractConfiguration {
    private final List<ConfigurationInterface> configList;

    public DelegatingConfiguration(List<ConfigurationInterface> configList) {
        this.configList = Collections.unmodifiableList(new ArrayList<ConfigurationInterface>(configList));
    }

    public DelegatingConfiguration(ConfigurationInterface ... configs) {
        this(Arrays.asList(configs));
    }

    @Override
    public Object getImpl(String aName) throws IllegalArgumentException {
        IllegalArgumentException e = null;
        for (ConfigurationInterface config : this.configList) {
            try {
                return config.getImpl(aName);
            }
            catch (IllegalArgumentException ex) {
                e = ex;
            }
        }
        throw e;
    }

    @Override
    public void setImpl(String aName, Object aValue) throws IllegalArgumentException, UnsupportedOperationException {
        IllegalArgumentException e = null;
        for (ConfigurationInterface config : this.configList) {
            try {
                config.getImpl(aName);
                config.setImpl(aName, aValue);
                return;
            }
            catch (IllegalArgumentException ex) {
                e = ex;
            }
        }
        throw e;
    }

    @Override
    public Iterator listImpl() {
        boolean workedAtAll = false;
        ArrayList settingList = new ArrayList();
        UnsupportedOperationException e = null;
        for (ConfigurationInterface config : this.configList) {
            try {
                Iterator list = config.listImpl();
                while (list.hasNext()) {
                    settingList.add(list.next());
                }
                workedAtAll = true;
            }
            catch (UnsupportedOperationException ex) {
                e = ex;
            }
        }
        if (!workedAtAll) {
            throw e == null ? new UnsupportedOperationException() : e;
        }
        return settingList.iterator();
    }
}

