/*
 * Decompiled with CFR 0.152.
 */
package webwork.action.standard;

import java.io.Serializable;
import java.util.StringTokenizer;
import javax.servlet.http.HttpServletRequest;
import webwork.action.ActionSupport;
import webwork.action.ServletRequestAware;

public class ClientInfo
extends ActionSupport
implements Serializable,
ServletRequestAware {
    private String browser = "Unknown";
    private float version;
    private String httpUserAgent = "";
    private String httpAccept = "";

    public void setUserAgent(String val) {
        this.httpUserAgent = val;
    }

    public void setAccept(String val) {
        this.httpAccept = val;
    }

    public String getBrowser() {
        return this.browser;
    }

    public float getVersion() {
        return this.version;
    }

    public boolean supportsType(String key) {
        return this.httpAccept.indexOf(key) != -1 || this.httpAccept.indexOf("*/*") != -1;
    }

    @Override
    public void setServletRequest(HttpServletRequest request) {
        if (request.getHeader("User-Agent") != null) {
            this.setUserAgent(request.getHeader("User-Agent"));
        }
        if (request.getHeader("Accept") != null) {
            this.setAccept(request.getHeader("Accept"));
        }
    }

    @Override
    protected String doExecute() throws Exception {
        Float versionFloat;
        StringTokenizer st = new StringTokenizer(this.httpUserAgent.toLowerCase());
        if (this.httpUserAgent.indexOf("Mozilla") != -1) {
            this.browser = "mozilla";
        }
        if (this.httpUserAgent.indexOf("MSIE") != -1) {
            this.browser = "msie";
        }
        if (this.httpUserAgent.indexOf("Opera") != -1) {
            this.browser = "opera";
        }
        if (this.httpUserAgent.indexOf("Lynx") != -1) {
            this.browser = "lynx";
        }
        String versionString = "0.0";
        int tokenCount = 0;
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            switch (tokenCount) {
                case 0: {
                    int start = token.indexOf("/") + 1;
                    if (this.browser.equals("mozilla")) {
                        versionString = token.substring(start);
                        break;
                    }
                    if (!this.browser.equals("lynx")) break;
                    int end = token.indexOf(".", start + 3);
                    if (token.indexOf("r", start) < end || end == -1) {
                        end = token.indexOf("r", start);
                    }
                    if (end == -1) {
                        end = start + 3;
                    }
                    versionString = token.substring(start, end);
                    break;
                }
                case 3: {
                    if (!this.browser.equals("msie")) break;
                    int end = token.length() - 1;
                    versionString = token.substring(0, end);
                    break;
                }
                case 8: {
                    if (!this.browser.equals("opera")) break;
                    versionString = token;
                }
            }
            ++tokenCount;
        }
        try {
            versionFloat = new Float(versionString);
        }
        catch (NumberFormatException nfe) {
            versionFloat = new Float(-10.0f);
        }
        this.version = !versionFloat.isNaN() && !versionFloat.isInfinite() ? versionFloat.floatValue() : -11.0f;
        return "success";
    }
}

