/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.upgrade.core.util;

import com.atlassian.fugue.Either;
import com.atlassian.upgrade.api.UpgradeContext;
import com.atlassian.upgrade.spi.LegacyUpgradeTask;
import com.atlassian.upgrade.spi.UpgradeTask;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class UpgradeTaskVerifier {
    public void verify(Collection<UpgradeTask> upgradeTasks) {
        List<UpgradeTaskWrapper> upgradeTaskWrappers = upgradeTasks.stream().map(x$0 -> new UpgradeTaskWrapper((UpgradeTask)x$0)).collect(Collectors.toList());
        this.verifyUniqueBuildNumbers(upgradeTaskWrappers);
    }

    public void verifyLegacy(Collection<LegacyUpgradeTask> upgradeTasks) {
        List<UpgradeTaskWrapper> upgradeTaskWrappers = upgradeTasks.stream().map(x$0 -> new UpgradeTaskWrapper((LegacyUpgradeTask)x$0)).collect(Collectors.toList());
        this.verifyUniqueBuildNumbers(upgradeTaskWrappers);
    }

    private void verifyUniqueBuildNumbers(Collection<UpgradeTaskWrapper> upgradeTasks) {
        Map<Integer, List<UpgradeTaskWrapper>> upgradeTasksByBuildNumber = this.groupTasksByBuildNumber(upgradeTasks);
        if (upgradeTasksByBuildNumber.size() != upgradeTasks.size()) {
            String errorMessage = this.prepareErrorMessage(upgradeTasksByBuildNumber);
            throw new IllegalStateException(errorMessage);
        }
    }

    private Map<Integer, List<UpgradeTaskWrapper>> groupTasksByBuildNumber(Collection<UpgradeTaskWrapper> upgradeTasks) {
        return upgradeTasks.stream().collect(Collectors.groupingBy(UpgradeTaskWrapper::getBuildNumber));
    }

    private String prepareErrorMessage(Map<Integer, List<UpgradeTaskWrapper>> upgradeTasksByBuildNumber) {
        Map<Integer, List<String>> tasksWithNotUniqueBuildNumbers = this.extractTasksWithNotUniqueBuildNumbers(upgradeTasksByBuildNumber);
        return "Detected not unique build numbers in upgrade tasks: " + tasksWithNotUniqueBuildNumbers;
    }

    Map<Integer, List<String>> extractTasksWithNotUniqueBuildNumbers(Map<Integer, List<UpgradeTaskWrapper>> upgradeTasksByBuildNumber) {
        return upgradeTasksByBuildNumber.entrySet().stream().filter(entry -> ((List)entry.getValue()).size() > 1).collect(Collectors.toMap(Map.Entry::getKey, this::extractClassNames));
    }

    private List<String> extractClassNames(Map.Entry<?, List<UpgradeTaskWrapper>> entry) {
        return entry.getValue().stream().map(UpgradeTaskWrapper::getOriginalClassName).collect(Collectors.toList());
    }

    class UpgradeTaskWrapper
    implements LegacyUpgradeTask,
    UpgradeTask {
        private final Either<UpgradeTask, LegacyUpgradeTask> delegate;

        UpgradeTaskWrapper(LegacyUpgradeTask legacyUpgradeTask) {
            this.delegate = Either.right((Object)legacyUpgradeTask);
        }

        UpgradeTaskWrapper(UpgradeTask upgradeTask) {
            this.delegate = Either.left((Object)upgradeTask);
        }

        public String getOriginalClassName() {
            return (String)this.delegate.fold(upgradeTask -> upgradeTask.getClass().getName(), legacyUpgradeTask -> legacyUpgradeTask.getClass().getName());
        }

        public int getBuildNumber() {
            return (Integer)this.delegate.fold(UpgradeTask::getBuildNumber, LegacyUpgradeTask::getBuildNumber);
        }

        public String getShortDescription() {
            return (String)this.delegate.fold(UpgradeTask::getShortDescription, LegacyUpgradeTask::getShortDescription);
        }

        public void runUpgrade(UpgradeContext upgradeContext) {
            this.delegate.fold(UpgradeTask::getShortDescription, LegacyUpgradeTask::getShortDescription);
        }
    }
}

