/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.upgrade.core;

import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.osgi.factory.OsgiPlugin;
import com.atlassian.upgrade.api.UpgradeContext;
import com.atlassian.upgrade.core.LegacyUpgradeTaskBuildNumberStorage;
import com.atlassian.upgrade.core.util.UpgradeTaskVerifier;
import com.atlassian.upgrade.spi.LegacyUpgradeTask;
import com.atlassian.upgrade.spi.LegacyUpgradeTaskFactory;
import com.google.common.base.Charsets;
import com.google.common.hash.Hashing;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LegacyUpgradeTaskFactoryProcessor {
    private static final Logger log = LoggerFactory.getLogger(LegacyUpgradeTaskFactoryProcessor.class);
    private final LegacyUpgradeTaskBuildNumberStorage legacyBuildNumberStorage;
    private final PluginAccessor pluginAccessor;
    private final UpgradeTaskVerifier upgradeTaskVerifier;

    public LegacyUpgradeTaskFactoryProcessor(LegacyUpgradeTaskBuildNumberStorage legacyBuildNumberStorage, PluginAccessor pluginAccessor, UpgradeTaskVerifier upgradeTaskVerifier) {
        this.legacyBuildNumberStorage = legacyBuildNumberStorage;
        this.pluginAccessor = pluginAccessor;
        this.upgradeTaskVerifier = upgradeTaskVerifier;
    }

    public boolean performLegacyUpgrades(String pluginKey, LegacyUpgradeTaskFactory upgradeTaskFactory, UpgradeContext upgradeContext) {
        boolean isSalUpgradeSuccessful = this.performSalUpgradeTasks(pluginKey, upgradeTaskFactory, upgradeContext);
        boolean isAoUpgradeSuccessful = this.performAoUpgradeTasks(pluginKey, upgradeTaskFactory, upgradeContext);
        return isSalUpgradeSuccessful && isAoUpgradeSuccessful;
    }

    private boolean performAoUpgradeTasks(String pluginKey, LegacyUpgradeTaskFactory upgradeTaskFactory, UpgradeContext upgradeContext) {
        return this.runUpgrades(this.computeAoCompatiblePrefix(pluginKey), this.legacyBuildNumberStorage::getAoBuildNumber, this.legacyBuildNumberStorage::setAoBuildNumber, () -> ((LegacyUpgradeTaskFactory)upgradeTaskFactory).getMinimumAoBuildNumber(), () -> ((LegacyUpgradeTaskFactory)upgradeTaskFactory).getAllAoUpgradeTasks(), upgradeContext);
    }

    private boolean performSalUpgradeTasks(String pluginKey, LegacyUpgradeTaskFactory upgradeTaskFactory, UpgradeContext upgradeContext) {
        return this.runUpgrades(pluginKey, this.legacyBuildNumberStorage::getSalBuildNumber, this.legacyBuildNumberStorage::setSalBuildNumber, () -> ((LegacyUpgradeTaskFactory)upgradeTaskFactory).getMinimumSalBuildNumber(), () -> ((LegacyUpgradeTaskFactory)upgradeTaskFactory).getAllSalUpgradeTasks(), upgradeContext);
    }

    private String computeAoCompatiblePrefix(String pluginKey) {
        Plugin plugin = Optional.ofNullable(this.pluginAccessor.getPlugin(pluginKey)).orElseThrow(() -> new IllegalStateException("Plugin with key [" + pluginKey + "] not found"));
        if (!(plugin instanceof OsgiPlugin)) {
            throw new IllegalArgumentException("Plugin " + plugin + " must be an OsgiPlugin");
        }
        String bundleSymbolicName = ((OsgiPlugin)plugin).getBundle().getSymbolicName();
        String hash = Hashing.md5().hashString((CharSequence)bundleSymbolicName, Charsets.UTF_8).toString();
        return "AO_" + hash.substring(hash.length() - 6, hash.length()).toUpperCase();
    }

    private boolean runUpgrades(String legacyKey, Function<String, Integer> buildNumberRetriever, BiConsumer<String, Integer> buildNumberUpdater, Supplier<Integer> minimalBuildNumberSupplier, Supplier<Collection<LegacyUpgradeTask>> taskSupplier, UpgradeContext upgradeContext) {
        Collection<LegacyUpgradeTask> legacyUpgradeTasks = taskSupplier.get();
        if (legacyUpgradeTasks.isEmpty()) {
            return true;
        }
        this.upgradeTaskVerifier.verifyLegacy(legacyUpgradeTasks);
        int currentBuildNumber = buildNumberRetriever.apply(legacyKey);
        int minimalBuildNumber = minimalBuildNumberSupplier.get();
        if (currentBuildNumber != 0 && currentBuildNumber < minimalBuildNumber) {
            log.error("{}: Current build number ({}) is smaller than the minimum build number ({})", new Object[]{legacyKey, currentBuildNumber, minimalBuildNumber});
            return false;
        }
        List tasksToPerform = legacyUpgradeTasks.stream().filter(t -> t.getBuildNumber() > currentBuildNumber).sorted((t, o) -> Integer.compare(t.getBuildNumber(), o.getBuildNumber())).collect(Collectors.toList());
        for (LegacyUpgradeTask task : tasksToPerform) {
            int nextBuildNumber = task.getBuildNumber();
            try {
                task.runUpgrade(upgradeContext);
            }
            catch (Throwable t2) {
                log.error("Legacy upgrade task [{},buildNumber={}] failed", new Object[]{legacyKey, task.getBuildNumber(), t2});
                return false;
            }
            buildNumberUpdater.accept(legacyKey, nextBuildNumber);
        }
        return true;
    }
}

