/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.upgrade.core;

import java.util.Optional;

public abstract class LegacyUpgradeTaskBuildNumberStorage {
    protected abstract Optional<Integer> getIntegerPluginSetting(String var1);

    protected abstract void putIntegerPluginSetting(String var1, int var2);

    private int getBuildNumberFromPluginSettings(String pluginSettingsKey) {
        return this.getIntegerPluginSetting(pluginSettingsKey).orElse(0);
    }

    private String getSalPluginSettingsKey(String pluginKey) {
        return pluginKey + ":build";
    }

    private String getAoPluginSettingsKey(String aoPrefix) {
        return aoPrefix + "_#";
    }

    public int getSalBuildNumber(String pluginKey) {
        return this.getBuildNumberFromPluginSettings(this.getSalPluginSettingsKey(pluginKey));
    }

    public void setSalBuildNumber(String pluginKey, int buildNumber) {
        this.putIntegerPluginSetting(this.getSalPluginSettingsKey(pluginKey), buildNumber);
    }

    public int getAoBuildNumber(String aoPrefix) {
        return this.getBuildNumberFromPluginSettings(this.getAoPluginSettingsKey(aoPrefix));
    }

    public void setAoBuildNumber(String aoPrefix, int buildNumber) {
        this.putIntegerPluginSetting(this.getAoPluginSettingsKey(aoPrefix), buildNumber);
    }
}

