/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.upgrade.core;

import com.atlassian.upgrade.api.UpgradeContext;
import com.atlassian.upgrade.core.LegacyUpgradeTaskFactoryProcessor;
import com.atlassian.upgrade.core.UpgradeTaskFactoryProcessor;
import com.atlassian.upgrade.core.dao.UpgradeTaskHistory;
import com.atlassian.upgrade.core.dao.UpgradeTaskHistoryDao;
import com.atlassian.upgrade.core.util.UpgradeTaskVerifier;
import com.atlassian.upgrade.spi.LegacyUpgradeTaskFactory;
import com.atlassian.upgrade.spi.UpgradeTask;
import com.atlassian.upgrade.spi.UpgradeTaskFactory;
import java.util.Collection;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultUpgradeTaskFactoryProcessor
implements UpgradeTaskFactoryProcessor {
    private final UpgradeTaskHistoryDao upgradeTaskHistoryDao;
    private final LegacyUpgradeTaskFactoryProcessor legacyUpgradeTaskProcessor;
    private final UpgradeTaskVerifier upgradeTaskVerifier;
    private static final Logger log = LoggerFactory.getLogger(DefaultUpgradeTaskFactoryProcessor.class);

    public DefaultUpgradeTaskFactoryProcessor(UpgradeTaskHistoryDao upgradeTaskHistoryDao, LegacyUpgradeTaskFactoryProcessor legacyUpgradeTaskProcessor, UpgradeTaskVerifier upgradeTaskVerifier) {
        this.upgradeTaskHistoryDao = upgradeTaskHistoryDao;
        this.legacyUpgradeTaskProcessor = legacyUpgradeTaskProcessor;
        this.upgradeTaskVerifier = upgradeTaskVerifier;
    }

    @Override
    public boolean performUpgrades(String factoryKey, UpgradeTaskFactory upgradeTaskFactory, UpgradeContext upgradeContext) {
        try {
            return this.performUpgradesUnsafe(factoryKey, upgradeTaskFactory, upgradeContext);
        }
        catch (Exception e) {
            log.error("Failed to run performUpgradesUnsafe tasks from factory {}", (Object)factoryKey, (Object)e);
            return false;
        }
    }

    private boolean performUpgradesUnsafe(String factoryKey, UpgradeTaskFactory upgradeTaskFactory, UpgradeContext upgradeContext) {
        if (this.historyHasCloudUpgradeTasks(factoryKey)) {
            log.error("Cannot upgrade {} because there are CLOUD upgrade tasks that have been completed", (Object)factoryKey);
            return false;
        }
        int currentBuildNumber = this.upgradeTaskHistoryDao.getDatabaseBuildNumber(factoryKey);
        if (currentBuildNumber <= 0 && upgradeTaskFactory instanceof LegacyUpgradeTaskFactory && !this.legacyUpgradeTaskProcessor.performLegacyUpgrades(factoryKey, (LegacyUpgradeTaskFactory)upgradeTaskFactory, upgradeContext)) {
            return false;
        }
        if (currentBuildNumber < upgradeTaskFactory.getMinimumBuildNumber()) {
            log.error(String.format("Current (%s) build number (%d) is smaller than the minimum build number (%s)", factoryKey, currentBuildNumber, upgradeTaskFactory.getMinimumBuildNumber()));
            return false;
        }
        Collection allUpgradeTasks = upgradeTaskFactory.getAllUpgradeTasks();
        this.upgradeTaskVerifier.verify(allUpgradeTasks);
        boolean anyFailed = allUpgradeTasks.stream().filter(task -> task.getBuildNumber() > currentBuildNumber).sorted((task1, task2) -> Integer.compare(task1.getBuildNumber(), task2.getBuildNumber())).filter(upgradeTask -> !this.runOneUpgradeTask(factoryKey, upgradeContext, (UpgradeTask)upgradeTask)).findFirst().isPresent();
        return !anyFailed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean runOneUpgradeTask(String factoryKey, UpgradeContext upgradeContext, UpgradeTask upgradeTask) {
        int taskId;
        Optional<Integer> maybeId = this.upgradeTaskHistoryDao.getIdByBuildNumber(factoryKey, upgradeTask.getBuildNumber());
        if (maybeId.isPresent()) {
            taskId = maybeId.get();
            log.debug("There's an entry from a previous upgrade attempt in upgrade history.Setting update status to IN_PROGRESS for task [{},buildNumber={}]", (Object)factoryKey, (Object)taskId);
            this.upgradeTaskHistoryDao.updateStatus(taskId, UpgradeTaskHistory.Status.IN_PROGRESS);
        } else {
            taskId = this.upgradeTaskHistoryDao.createUpgradeTaskHistory(new UpgradeTaskHistory(null, factoryKey, upgradeTask.getBuildNumber(), UpgradeTaskHistory.Status.IN_PROGRESS, UpgradeTaskHistory.UpgradeType.SERVER));
        }
        long start = System.currentTimeMillis();
        boolean success = false;
        try {
            upgradeTask.runUpgrade(upgradeContext);
            this.upgradeTaskHistoryDao.updateStatus(taskId, UpgradeTaskHistory.Status.COMPLETED);
            success = true;
            boolean bl = true;
            return bl;
        }
        catch (Throwable e) {
            log.error("Upgrade task [{},buildNumber={}] failed", new Object[]{factoryKey, upgradeTask.getBuildNumber(), e});
            this.upgradeTaskHistoryDao.updateStatus(taskId, UpgradeTaskHistory.Status.FAILED);
            boolean bl = false;
            return bl;
        }
        finally {
            this.logCompletedTask(factoryKey, upgradeTask.getBuildNumber(), success, start);
        }
    }

    private boolean historyHasCloudUpgradeTasks(String factoryKey) {
        Collection<UpgradeTaskHistory> history = this.upgradeTaskHistoryDao.getAllUpgradeTaskHistory(factoryKey);
        return history.stream().filter(task -> UpgradeTaskHistory.UpgradeType.CLOUD.equals((Object)task.getUpgradeType())).findFirst().isPresent();
    }

    private void logCompletedTask(String factoryKey, int buildNumber, boolean success, long startTime) {
        if (success) {
            log.info("Upgrade task [factory={},buildNumber={}] completed in {} milliseconds", new Object[]{factoryKey, buildNumber, System.currentTimeMillis() - startTime});
        } else {
            log.warn("Failed to complete upgrade task [factory={},buildNumber={}]", (Object)factoryKey, (Object)buildNumber);
        }
    }
}

