/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.sourcemap;

import com.atlassian.sourcemap.SourceMap;
import com.atlassian.sourcemap.SourceMapImpl;
import java.util.ArrayList;
import java.util.List;

public class SourceMapJoiner {
    List<SourceMapWithOffset> sourceMaps = new ArrayList<SourceMapWithOffset>();

    public void add(SourceMap sourceMap, int length) {
        this.add(sourceMap, length, 0);
    }

    public void add(SourceMap sourceMap, int length, int offset) {
        this.sourceMaps.add(new SourceMapWithOffset(sourceMap, length, offset));
    }

    public SourceMap join() {
        SourceMapImpl joinedMap = new SourceMapImpl();
        int lineOffset = 0;
        for (SourceMapWithOffset sourceMapWithOffset : this.sourceMaps) {
            int offset = sourceMapWithOffset.offset;
            int linesCount = sourceMapWithOffset.linesCount;
            SourceMap sourceMap = sourceMapWithOffset.sourceMap;
            int finalLineOffset = lineOffset += offset;
            if (sourceMap != null) {
                sourceMap.eachMapping(mapping -> joinedMap.addMapping(finalLineOffset + mapping.getGeneratedLine(), mapping.getGeneratedColumn(), mapping.getSourceLine(), mapping.getSourceColumn(), mapping.getSourceFileName(), mapping.getSourceSymbolName()));
            }
            lineOffset += linesCount - offset;
        }
        return joinedMap;
    }

    static class SourceMapWithOffset {
        SourceMap sourceMap;
        int offset;
        int linesCount;

        public SourceMapWithOffset(SourceMap sourceMap, int linesCount, int offset) {
            this.sourceMap = sourceMap;
            this.linesCount = linesCount;
            this.offset = offset;
        }
    }
}

