/*
 * Decompiled with CFR 0.152.
 */
package com.querydsl.sql.mysql;

import com.querydsl.core.QueryFlag;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.sql.AbstractSQLQueryFactory;
import com.querydsl.sql.Configuration;
import com.querydsl.sql.MySQLTemplates;
import com.querydsl.sql.RelationalPath;
import com.querydsl.sql.SQLTemplates;
import com.querydsl.sql.dml.SQLInsertClause;
import com.querydsl.sql.mysql.MySQLQuery;
import com.querydsl.sql.mysql.MySQLReplaceClause;
import java.sql.Connection;
import javax.inject.Provider;

public class MySQLQueryFactory
extends AbstractSQLQueryFactory<MySQLQuery<?>> {
    public MySQLQueryFactory(Configuration configuration, Provider<Connection> connection) {
        super(configuration, connection);
    }

    public MySQLQueryFactory(Provider<Connection> connection) {
        this(new Configuration(new MySQLTemplates()), connection);
    }

    public MySQLQueryFactory(SQLTemplates templates, Provider<Connection> connection) {
        this(new Configuration(templates), connection);
    }

    public SQLInsertClause insertIgnore(RelationalPath<?> entity) {
        SQLInsertClause insert = this.insert(entity);
        insert.addFlag(QueryFlag.Position.START_OVERRIDE, "insert ignore into ");
        return insert;
    }

    public SQLInsertClause insertOnDuplicateKeyUpdate(RelationalPath<?> entity, String clause) {
        SQLInsertClause insert = this.insert(entity);
        insert.addFlag(QueryFlag.Position.END, " on duplicate key update " + clause);
        return insert;
    }

    public SQLInsertClause insertOnDuplicateKeyUpdate(RelationalPath<?> entity, Expression<?> clause) {
        SQLInsertClause insert = this.insert(entity);
        insert.addFlag(QueryFlag.Position.END, (Expression<?>)ExpressionUtils.template(String.class, (String)" on duplicate key update {0}", (Object[])new Object[]{clause}));
        return insert;
    }

    @Override
    public MySQLQuery<?> query() {
        return new MySQLQuery((Provider<Connection>)this.connection, this.configuration);
    }

    public MySQLReplaceClause replace(RelationalPath<?> entity) {
        return new MySQLReplaceClause((Connection)this.connection.get(), this.configuration, entity);
    }
}

