/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.workflow.util.ejb.remote;

import com.opensymphony.module.propertyset.PropertySet;
import com.opensymphony.workflow.FunctionProvider;
import com.opensymphony.workflow.FunctionProviderRemote;
import com.opensymphony.workflow.WorkflowException;
import java.lang.reflect.Method;
import java.rmi.RemoteException;
import java.util.Hashtable;
import java.util.Map;
import javax.ejb.EJBHome;
import javax.naming.InitialContext;
import javax.rmi.PortableRemoteObject;

public class RemoteEJBFunctionProvider
implements FunctionProvider {
    @Override
    public void execute(Map transientVars, Map args, PropertySet ps) throws WorkflowException {
        FunctionProviderRemote sessionBean;
        String ejbLocation = (String)args.get("ejb.location");
        Hashtable env = null;
        for (Map.Entry entry : args.entrySet()) {
            if (env == null) {
                env = new Hashtable();
            }
            if (!((String)entry.getKey()).startsWith("java.naming.")) continue;
            env.put(entry.getKey(), entry.getValue());
        }
        try {
            EJBHome home = (EJBHome)PortableRemoteObject.narrow((Object)new InitialContext(env).lookup(ejbLocation), EJBHome.class);
            Method create = home.getClass().getMethod("create", new Class[0]);
            sessionBean = (FunctionProviderRemote)create.invoke((Object)home, new Object[0]);
        }
        catch (Exception e) {
            String message = "Could not get handle to remote EJB at: " + ejbLocation;
            throw new WorkflowException(message, e);
        }
        try {
            sessionBean.execute(transientVars, args, ps);
        }
        catch (RemoteException e) {
            String message = "Remote exception from EJB at: " + ejbLocation;
            throw new WorkflowException(message, e);
        }
    }
}

