/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.workflow.util.bsf;

import com.opensymphony.module.propertyset.PropertySet;
import com.opensymphony.util.TextUtils;
import com.opensymphony.workflow.Register;
import com.opensymphony.workflow.WorkflowContext;
import com.opensymphony.workflow.WorkflowException;
import com.opensymphony.workflow.spi.WorkflowEntry;
import java.util.Map;
import org.apache.bsf.BSFEngine;
import org.apache.bsf.BSFException;
import org.apache.bsf.BSFManager;

public class BSFRegister
implements Register {
    @Override
    public Object registerVariable(WorkflowContext context, WorkflowEntry entry, Map args, PropertySet ps) throws WorkflowException {
        String language = (String)args.get("language");
        String source = (String)args.get("source");
        int row = TextUtils.parseInt((String)((String)args.get("row")));
        int col = TextUtils.parseInt((String)((String)args.get("col")));
        String script = (String)args.get("script");
        BSFManager mgr = new BSFManager();
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        if (loader != null) {
            mgr.setClassLoader(loader);
        }
        mgr.registerBean("propertySet", (Object)ps);
        mgr.registerBean("entry", (Object)entry);
        mgr.registerBean("context", (Object)context);
        try {
            BSFEngine engine = mgr.loadScriptingEngine(language);
            return engine.eval(source, row, col, (Object)script);
        }
        catch (BSFException e) {
            String message = "Could not get object registered in to variable map";
            throw new WorkflowException(message, e);
        }
    }
}

