/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.workflow.util.beanshell;

import bsh.EvalError;
import bsh.Interpreter;
import bsh.TargetError;
import com.opensymphony.module.propertyset.PropertySet;
import com.opensymphony.workflow.FunctionProvider;
import com.opensymphony.workflow.WorkflowContext;
import com.opensymphony.workflow.WorkflowException;
import com.opensymphony.workflow.spi.WorkflowEntry;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class BeanShellFunctionProvider
implements FunctionProvider {
    private static final Log log = LogFactory.getLog(BeanShellFunctionProvider.class);

    @Override
    public void execute(Map transientVars, Map args, PropertySet ps) throws WorkflowException {
        Interpreter i;
        String script = (String)args.get("script");
        WorkflowContext context = (WorkflowContext)transientVars.get("context");
        WorkflowEntry entry = (WorkflowEntry)transientVars.get("entry");
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        try {
            i = new Interpreter();
            if (loader != null) {
                i.setClassLoader(loader);
            }
            i.set("entry", (Object)entry);
            i.set("context", (Object)context);
            i.set("transientVars", (Object)transientVars);
            i.set("propertySet", (Object)ps);
            i.set("args", (Object)args);
        }
        catch (EvalError evalError) {
            String message = "Could not set values for BSH script";
            log.error((Object)message, (Throwable)evalError);
            throw new WorkflowException(message, evalError);
        }
        try {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Trying to execute script:\n" + script + "\n"));
            }
            i.eval(script);
        }
        catch (TargetError targetError) {
            if (targetError.getTarget() instanceof WorkflowException) {
                throw (WorkflowException)targetError.getTarget();
            }
            String message = "Evaluation error while running BSH function script";
            throw new WorkflowException(message, targetError.getTarget());
        }
        catch (EvalError evalError) {
            String message = "Evaluation error while running BSH function script";
            log.error((Object)message, (Throwable)evalError);
            throw new WorkflowException(message, evalError);
        }
        finally {
            if (loader != null) {
                i.setClassLoader(null);
            }
        }
    }
}

