/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.workflow.util;

import com.opensymphony.module.propertyset.PropertySet;
import com.opensymphony.util.TextUtils;
import com.opensymphony.workflow.FunctionProvider;
import com.opensymphony.workflow.spi.WorkflowEntry;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.impl.StdSchedulerFactory;

public class UnscheduleJob
implements FunctionProvider {
    private static final Log log = LogFactory.getLog(UnscheduleJob.class);

    @Override
    public void execute(Map transientVars, Map args, PropertySet ps) {
        try {
            WorkflowEntry entry = (WorkflowEntry)transientVars.get("entry");
            log.info((Object)("Starting to unschedule job for WF #" + entry.getId()));
            String schedulerName = (String)args.get("schedulerName");
            Scheduler s = null;
            StdSchedulerFactory factory = new StdSchedulerFactory();
            s = schedulerName == null || "".equals(schedulerName.trim()) ? factory.getScheduler() : factory.getScheduler(schedulerName);
            boolean txHack = TextUtils.parseBoolean((String)((String)args.get("txHack")));
            String triggerName = (String)args.get("triggerName");
            String groupName = (String)args.get("groupName");
            triggerName = triggerName + ":" + entry.getId();
            groupName = groupName + ":" + entry.getId();
            if (txHack && !s.isPaused() && !s.isShutdown()) {
                s.pause();
                try {
                    s.unscheduleJob(triggerName, groupName);
                }
                catch (SchedulerException e) {
                    throw e;
                }
                finally {
                    s.start();
                }
            } else {
                s.unscheduleJob(triggerName, groupName);
            }
            log.info((Object)"Job unscheduled");
        }
        catch (Exception e) {
            log.error((Object)"Could not unschedule job", (Throwable)e);
        }
    }
}

