/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.workflow.util;

import com.opensymphony.workflow.Condition;
import com.opensymphony.workflow.FunctionProvider;
import com.opensymphony.workflow.Register;
import com.opensymphony.workflow.TypeResolver;
import com.opensymphony.workflow.Validator;
import com.opensymphony.workflow.WorkflowException;
import java.util.HashMap;
import java.util.Map;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class SpringTypeResolver
extends TypeResolver
implements ApplicationContextAware {
    private static final String BEANNAME = "bean.name";
    private static final String SPRING = "spring";
    private ApplicationContext applicationContext;
    private Map springFunctions = new HashMap();

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    @Override
    public Condition getCondition(String type, Map args) throws WorkflowException {
        if (SPRING.equals(type)) {
            return (Condition)this.getApplicationContext().getBean((String)args.get(BEANNAME));
        }
        return super.getCondition(type, args);
    }

    public void setConditions(Map conditions) {
        this.conditions = conditions;
    }

    @Override
    public FunctionProvider getFunction(String type, Map args) throws WorkflowException {
        if (SPRING.equals(type)) {
            return (FunctionProvider)this.getApplicationContext().getBean((String)args.get(BEANNAME));
        }
        String className = (String)this.springFunctions.get(type);
        if (className == null) {
            className = (String)args.get("class.name");
        }
        if (className != null) {
            return (FunctionProvider)this.loadObject(className);
        }
        return super.getFunction(type, args);
    }

    public void setFunctions(Map functions) {
        this.springFunctions = functions;
    }

    @Override
    public Register getRegister(String type, Map args) throws WorkflowException {
        if (SPRING.equals(type)) {
            return (Register)this.getApplicationContext().getBean((String)args.get(BEANNAME));
        }
        return super.getRegister(type, args);
    }

    public void setRegisters(Map registers) {
        this.registers = registers;
    }

    @Override
    public Validator getValidator(String type, Map args) throws WorkflowException {
        if (SPRING.equals(type)) {
            return (Validator)this.getApplicationContext().getBean((String)args.get(BEANNAME));
        }
        return super.getValidator(type, args);
    }

    public void setValidators(Map validators) {
        this.validators = validators;
    }

    private ApplicationContext getApplicationContext() {
        return this.applicationContext;
    }
}

