/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.workflow.util;

import com.opensymphony.module.propertyset.PropertySet;
import com.opensymphony.workflow.FunctionProvider;
import com.opensymphony.workflow.config.Configuration;
import com.opensymphony.workflow.util.VariableResolver;
import java.util.Date;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.mail.Address;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SendEmail
implements FunctionProvider {
    private static final Log log = LogFactory.getLog(SendEmail.class);

    @Override
    public void execute(Map transientVars, Map args, PropertySet ps) {
        String to = (String)args.get("to");
        String from = (String)args.get("from");
        String subject = (String)args.get("subject");
        String cc = (String)args.get("cc");
        String m = (String)args.get("message");
        String smtpHost = (String)args.get("smtpHost");
        boolean parseVariables = "true".equals(args.get("parseVariables"));
        Configuration config = (Configuration)transientVars.get("configuration");
        try {
            Properties props = new Properties();
            props.put("mail.smtp.host", smtpHost);
            Session sendMailSession = Session.getInstance((Properties)props, null);
            Transport transport = sendMailSession.getTransport("smtp");
            MimeMessage message = new MimeMessage(sendMailSession);
            message.setFrom((Address)new InternetAddress(from));
            HashSet<InternetAddress> toSet = new HashSet<InternetAddress>();
            VariableResolver variableResolver = config.getVariableResolver();
            StringTokenizer st = new StringTokenizer(parseVariables ? variableResolver.translateVariables(to, transientVars, ps).toString() : to, ", ");
            while (st.hasMoreTokens()) {
                String user = st.nextToken();
                toSet.add(new InternetAddress(user));
            }
            message.setRecipients(Message.RecipientType.TO, (Address[])toSet.toArray(new InternetAddress[toSet.size()]));
            HashSet<InternetAddress> ccSet = null;
            if (cc != null) {
                ccSet = new HashSet<InternetAddress>();
                if (parseVariables) {
                    cc = variableResolver.translateVariables(cc, transientVars, ps).toString();
                }
                st = new StringTokenizer(cc, ", ");
                while (st.hasMoreTokens()) {
                    String user = st.nextToken();
                    ccSet.add(new InternetAddress(user));
                }
            }
            if (ccSet != null && ccSet.size() > 0) {
                message.setRecipients(Message.RecipientType.CC, (Address[])ccSet.toArray(new InternetAddress[ccSet.size()]));
            }
            message.setSubject(parseVariables ? variableResolver.translateVariables(subject, transientVars, ps).toString() : subject);
            message.setSentDate(new Date());
            message.setText(parseVariables ? variableResolver.translateVariables(m, transientVars, ps).toString() : m);
            message.saveChanges();
            transport.connect();
            transport.sendMessage((Message)message, message.getAllRecipients());
            transport.close();
        }
        catch (MessagingException e) {
            log.error((Object)"Error sending email:", (Throwable)e);
        }
    }
}

