/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.workflow.spi.prevayler;

import com.opensymphony.module.propertyset.PropertySet;
import com.opensymphony.workflow.StoreException;
import com.opensymphony.workflow.query.WorkflowExpressionQuery;
import com.opensymphony.workflow.query.WorkflowQuery;
import com.opensymphony.workflow.spi.Step;
import com.opensymphony.workflow.spi.WorkflowEntry;
import com.opensymphony.workflow.spi.WorkflowStore;
import com.opensymphony.workflow.spi.prevayler.WorkflowSystem;
import java.io.IOException;
import java.io.Serializable;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.prevayler.Prevayler;
import org.prevayler.PrevaylerFactory;
import org.prevayler.Query;
import org.prevayler.Transaction;
import org.prevayler.TransactionWithQuery;

public class PrevaylerWorkflowStore
implements WorkflowStore,
Serializable {
    private transient Prevayler _prevayler = null;
    private transient String _prevalenceBase;
    private WorkflowStore _store = null;

    public PrevaylerWorkflowStore() throws IOException, ClassNotFoundException {
        this("WorkflowPrevaylenceBase");
    }

    public PrevaylerWorkflowStore(String prevalenceBase) throws IOException, ClassNotFoundException {
        this._prevalenceBase = prevalenceBase;
        this._store = new WorkflowSystem();
    }

    @Override
    public void setEntryState(long entryId, int state) throws StoreException {
        Object[] o = new Object[]{new Long(entryId), new Integer(state)};
        try {
            this._prevayler.execute((Transaction)new TransactionImpl(o){

                @Override
                public void execute(WorkflowSystem store) {
                    Object[] o = (Object[])this._object;
                    long entryId = (Long)o[0];
                    int state = (Integer)o[1];
                    try {
                        store.setEntryState(entryId, state);
                    }
                    catch (StoreException e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }
        catch (Exception e) {
            if (e.getCause() instanceof StoreException) {
                throw (StoreException)e.getCause();
            }
            throw new StoreException(e);
        }
    }

    @Override
    public PropertySet getPropertySet(long entryId) throws StoreException {
        try {
            return (PropertySet)this._prevayler.execute((TransactionWithQuery)new TransactionWithQueryImpl(new Long(entryId)){

                @Override
                public Object execute(WorkflowSystem store) throws StoreException {
                    return store.getPropertySet((Long)this._object);
                }
            });
        }
        catch (Exception e) {
            throw new StoreException(e);
        }
    }

    @Override
    public Step createCurrentStep(long entryId, int stepId, String owner, Date startDate, Date dueDate, String status, long[] previousIds) throws StoreException {
        Object[] oArray = new Object[]{new Long(entryId), new Integer(stepId), owner, startDate, dueDate, status, previousIds};
        try {
            return (Step)this._prevayler.execute((TransactionWithQuery)new TransactionWithQueryImpl(oArray){

                @Override
                public Object execute(WorkflowSystem store) throws StoreException {
                    Object[] o = (Object[])this._object;
                    long entryId = (Long)o[0];
                    int stepId = (Integer)o[1];
                    String owner = (String)o[2];
                    Date startDate = (Date)o[3];
                    Date dueDate = (Date)o[4];
                    String status = (String)o[5];
                    long[] previousIds = (long[])o[6];
                    return store.createCurrentStep(entryId, stepId, owner, startDate, dueDate, status, previousIds);
                }
            });
        }
        catch (Exception e) {
            throw new StoreException(e);
        }
    }

    @Override
    public WorkflowEntry createEntry(String workflowName) throws StoreException {
        try {
            return (WorkflowEntry)this._prevayler.execute((TransactionWithQuery)new TransactionWithQueryImpl(workflowName){

                @Override
                public Object execute(WorkflowSystem store) throws StoreException {
                    return store.createEntry((String)this._object);
                }
            });
        }
        catch (Exception e) {
            throw new StoreException(e);
        }
    }

    @Override
    public List findCurrentSteps(long entryId) throws StoreException {
        try {
            return (List)this._prevayler.execute((TransactionWithQuery)new TransactionWithQueryImpl(new Long(entryId)){

                @Override
                public Object execute(WorkflowSystem store) throws StoreException {
                    return store.findCurrentSteps((Long)this._object);
                }
            });
        }
        catch (Exception e) {
            throw new StoreException(e);
        }
    }

    @Override
    public WorkflowEntry findEntry(long entryId) throws StoreException {
        try {
            return (WorkflowEntry)this._prevayler.execute((TransactionWithQuery)new TransactionWithQueryImpl(new Long(entryId)){

                @Override
                public Object execute(WorkflowSystem store) throws StoreException {
                    return store.findEntry((Long)this._object);
                }
            });
        }
        catch (Exception e) {
            throw new StoreException(e);
        }
    }

    @Override
    public List findHistorySteps(long entryId) throws StoreException {
        try {
            return (List)this._prevayler.execute((TransactionWithQuery)new TransactionWithQueryImpl(new Long(entryId)){

                @Override
                public Object execute(WorkflowSystem store) throws StoreException {
                    return store.findHistorySteps((Long)this._object);
                }
            });
        }
        catch (Exception e) {
            throw new StoreException(e);
        }
    }

    @Override
    public void init(Map props) throws StoreException {
        String value;
        String transientKey;
        this._store.init(props);
        boolean isTransient = false;
        String pBaseKey = "base";
        if (props.containsKey(pBaseKey)) {
            this._prevalenceBase = (String)props.get(pBaseKey);
        }
        if (props.containsKey(transientKey = "transient") && (value = (String)props.get(transientKey)).equalsIgnoreCase("true")) {
            isTransient = true;
        }
        try {
            this.initializePrevaylenceSystem(this._prevalenceBase, isTransient);
        }
        catch (Exception e) {
            throw new StoreException(e);
        }
    }

    @Override
    public Step markFinished(Step step, int actionId, Date finishDate, String status, String caller) throws StoreException {
        Object[] oArray = new Object[]{step, new Integer(actionId), finishDate, status, caller};
        try {
            return (Step)this._prevayler.execute((TransactionWithQuery)new TransactionWithQueryImpl(oArray){

                @Override
                public Object execute(WorkflowSystem store) throws StoreException {
                    Object[] o = (Object[])this._object;
                    Step step = (Step)o[0];
                    int actionId = (Integer)o[1];
                    Date finishDate = (Date)o[2];
                    String status = (String)o[3];
                    String caller = (String)o[4];
                    return store.markFinished(step, actionId, finishDate, status, caller);
                }
            });
        }
        catch (Exception e) {
            throw new StoreException(e);
        }
    }

    @Override
    public void moveToHistory(Step step) throws StoreException {
        try {
            this._prevayler.execute((Transaction)new TransactionImpl(step){

                @Override
                public void execute(WorkflowSystem store) throws StoreException {
                    store.moveToHistory((Step)this._object);
                }
            });
        }
        catch (Exception e) {
            throw new StoreException(e);
        }
    }

    @Override
    public List query(WorkflowQuery query) throws StoreException {
        try {
            return (List)this._prevayler.execute((Query)new QueryImpl(query){

                @Override
                public Object execute(WorkflowSystem store) throws StoreException {
                    return store.query((WorkflowQuery)this._object);
                }
            });
        }
        catch (Exception e) {
            throw new StoreException(e);
        }
    }

    @Override
    public List query(WorkflowExpressionQuery query) throws StoreException {
        try {
            return (List)this._prevayler.execute((Query)new QueryImpl(query){

                @Override
                public Object execute(WorkflowSystem store) throws StoreException {
                    return store.query((WorkflowExpressionQuery)this._object);
                }
            });
        }
        catch (Exception e) {
            throw new StoreException(e);
        }
    }

    private void initializePrevaylenceSystem(String prevalenceBase, boolean isTransient) throws IOException, ClassNotFoundException {
        this._prevayler = isTransient ? PrevaylerFactory.createTransientPrevayler((Serializable)((Serializable)((Object)this._store))) : PrevaylerFactory.createPrevayler((Serializable)((Serializable)((Object)this._store)), (String)prevalenceBase);
    }

    private abstract class TransactionWithQueryImpl
    extends ObjectActioner
    implements TransactionWithQuery {
        public TransactionWithQueryImpl(Object object) {
            super(object);
        }

        public abstract Object execute(WorkflowSystem var1) throws StoreException;

        public Object executeAndQuery(Object prevSystem, Date ignored) throws Exception {
            return this.execute((WorkflowSystem)prevSystem);
        }
    }

    private abstract class TransactionImpl
    extends ObjectActioner
    implements Transaction {
        public TransactionImpl(Object object) {
            super(object);
        }

        public abstract void execute(WorkflowSystem var1) throws StoreException;

        public void executeOn(Object prevSystem, Date ignored) {
            try {
                this.execute((WorkflowSystem)prevSystem);
            }
            catch (StoreException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private abstract class QueryImpl
    extends ObjectActioner
    implements Query {
        public QueryImpl(Object object) {
            super(object);
        }

        public abstract Object execute(WorkflowSystem var1) throws StoreException;

        public Object query(Object prevSystem, Date ignored) throws Exception {
            return this.execute((WorkflowSystem)prevSystem);
        }
    }

    private class ObjectActioner
    implements Serializable {
        protected Object _object = null;

        public ObjectActioner() {
        }

        public ObjectActioner(Object object) {
            this._object = object;
        }
    }
}

