/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.workflow.spi.ojb;

import com.opensymphony.module.propertyset.PropertySet;
import com.opensymphony.module.propertyset.PropertySetManager;
import com.opensymphony.workflow.QueryNotSupportedException;
import com.opensymphony.workflow.StoreException;
import com.opensymphony.workflow.query.WorkflowExpressionQuery;
import com.opensymphony.workflow.query.WorkflowQuery;
import com.opensymphony.workflow.spi.Step;
import com.opensymphony.workflow.spi.WorkflowEntry;
import com.opensymphony.workflow.spi.WorkflowStore;
import com.opensymphony.workflow.spi.ojb.OJBCurrentStep;
import com.opensymphony.workflow.spi.ojb.OJBHistoryStep;
import com.opensymphony.workflow.spi.ojb.OJBStep;
import com.opensymphony.workflow.spi.ojb.OJBWorkflowEntry;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ojb.broker.PBFactoryException;
import org.apache.ojb.broker.PersistenceBroker;
import org.apache.ojb.broker.PersistenceBrokerFactory;
import org.apache.ojb.broker.query.Criteria;
import org.apache.ojb.broker.query.Query;
import org.apache.ojb.broker.query.QueryByCriteria;
import org.apache.ojb.broker.query.ReportQueryByCriteria;

public class OJBWorkflowStore
implements WorkflowStore {
    private static final Log log = LogFactory.getLog(OJBWorkflowStore.class);

    @Override
    public void setEntryState(long entryId, int state) throws StoreException {
        try (PersistenceBroker broker = null;){
            broker = this.getBroker();
            Criteria criteria = new Criteria();
            criteria.addEqualTo("id", (Object)new Long(entryId));
            QueryByCriteria query = new QueryByCriteria(OJBWorkflowEntry.class, criteria);
            OJBWorkflowEntry entry = (OJBWorkflowEntry)broker.getObjectByQuery((Query)query);
            entry.setState(state);
            broker.store((Object)entry);
        }
    }

    @Override
    public PropertySet getPropertySet(long entryId) throws StoreException {
        HashMap<String, String> args = new HashMap<String, String>();
        args.put("globalKey", "osff_" + entryId);
        return PropertySetManager.getInstance((String)"ojb", args);
    }

    @Override
    public Step createCurrentStep(long entryId, int stepId, String owner, Date startDate, Date dueDate, String status, long[] previousIds) throws StoreException {
        OJBCurrentStep step = new OJBCurrentStep();
        try (PersistenceBroker broker = null;){
            broker = this.getBroker();
            Criteria criteria = new Criteria();
            criteria.addEqualTo("id", (Object)new Long(entryId));
            QueryByCriteria requete = new QueryByCriteria(OJBWorkflowEntry.class, criteria);
            OJBWorkflowEntry entry = (OJBWorkflowEntry)broker.getObjectByQuery((Query)requete);
            step.setEntry(entry);
            step.setStepId(stepId);
            step.setOwner(owner);
            step.setStartDate(startDate);
            step.setDueDate(dueDate);
            step.setStatus(status);
            ArrayList<Long> stepIdList = new ArrayList<Long>(previousIds.length);
            for (int i = 0; i < previousIds.length; ++i) {
                long previousId = previousIds[i];
                stepIdList.add(new Long(previousId));
            }
            if (!stepIdList.isEmpty()) {
                criteria = new Criteria();
                criteria.addIn("id", stepIdList);
                requete = new QueryByCriteria(OJBCurrentStep.class, criteria);
                Collection clPreviousStep = broker.getCollectionByQuery((Query)requete);
                step.setPreviousSteps(new ArrayList(clPreviousStep));
            } else {
                step.setPreviousSteps(Collections.EMPTY_LIST);
            }
            if (entry.getCurrentSteps() == null) {
                ArrayList<OJBCurrentStep> cSteps = new ArrayList<OJBCurrentStep>(1);
                cSteps.add(step);
                entry.setCurrentSteps(cSteps);
            } else {
                entry.getCurrentSteps().add(step);
            }
            broker.store((Object)entry);
        }
        return step;
    }

    @Override
    public WorkflowEntry createEntry(String workflowName) throws StoreException {
        PersistenceBroker broker = null;
        OJBWorkflowEntry entry = new OJBWorkflowEntry();
        entry.setState(0);
        entry.setWorkflowName(workflowName);
        try {
            broker = this.getBroker();
            broker.store((Object)entry);
        }
        catch (Exception e) {
            throw new StoreException("Error creating new workflow entry", e);
        }
        finally {
            if (broker != null) {
                broker.close();
            }
        }
        return entry;
    }

    @Override
    public List findCurrentSteps(long entryId) throws StoreException {
        Collection clStep = Collections.EMPTY_LIST;
        try (PersistenceBroker broker = null;){
            broker = this.getBroker();
            Criteria critere = new Criteria();
            critere.addEqualTo("entry.id", (Object)new Long(entryId));
            QueryByCriteria requete = new QueryByCriteria(OJBCurrentStep.class, critere);
            clStep = broker.getCollectionByQuery((Query)requete);
        }
        return new ArrayList(clStep);
    }

    @Override
    public WorkflowEntry findEntry(long entryId) throws StoreException {
        OJBWorkflowEntry entry = null;
        try (PersistenceBroker broker = null;){
            broker = this.getBroker();
            Criteria criteria = new Criteria();
            criteria.addEqualTo("id", (Object)new Long(entryId));
            QueryByCriteria query = new QueryByCriteria(OJBWorkflowEntry.class, criteria);
            entry = (OJBWorkflowEntry)broker.getObjectByQuery((Query)query);
        }
        return entry;
    }

    @Override
    public List findHistorySteps(long entryId) throws StoreException {
        Collection clStep = Collections.EMPTY_LIST;
        try (PersistenceBroker broker = null;){
            broker = this.getBroker();
            Criteria critere = new Criteria();
            critere.addEqualTo("entry.id", (Object)new Long(entryId));
            QueryByCriteria requete = new QueryByCriteria(OJBHistoryStep.class, critere);
            clStep = broker.getCollectionByQuery((Query)requete);
        }
        return new ArrayList(clStep);
    }

    @Override
    public void init(Map props) throws StoreException {
    }

    @Override
    public Step markFinished(Step step, int actionId, Date finishDate, String status, String caller) throws StoreException {
        OJBCurrentStep currentStep = (OJBCurrentStep)step;
        try (PersistenceBroker broker = null;){
            broker = this.getBroker();
            currentStep.setActionId(actionId);
            currentStep.setFinishDate(finishDate);
            currentStep.setStatus(status);
            currentStep.setCaller(caller);
            broker.store((Object)currentStep);
        }
        return step;
    }

    @Override
    public void moveToHistory(Step step) throws StoreException {
        try (PersistenceBroker broker = null;){
            broker = this.getBroker();
            Criteria criteria = new Criteria();
            criteria.addEqualTo("id", (Object)new Long(step.getEntryId()));
            QueryByCriteria query = new QueryByCriteria(OJBWorkflowEntry.class, criteria);
            OJBWorkflowEntry entry = (OJBWorkflowEntry)broker.getObjectByQuery((Query)query);
            if (entry != null) {
                OJBHistoryStep hstep = new OJBHistoryStep((OJBStep)step);
                entry.getCurrentSteps().remove(step);
                if (entry.getHistorySteps() == null) {
                    ArrayList<OJBHistoryStep> hSteps = new ArrayList<OJBHistoryStep>(1);
                    hSteps.add(hstep);
                    entry.setHistorySteps(hSteps);
                } else {
                    entry.getHistorySteps().add(hstep);
                }
                broker.delete((Object)new OJBCurrentStep((OJBStep)step));
                broker.store((Object)entry);
            }
        }
    }

    @Override
    public List query(WorkflowExpressionQuery query) throws StoreException {
        throw new QueryNotSupportedException("OJB Store does not support WorkflowExpressionQuery");
    }

    @Override
    public List query(WorkflowQuery query) throws StoreException {
        ArrayList<Long> results = new ArrayList<Long>();
        try (PersistenceBroker broker = null;){
            broker = this.getBroker();
            int qtype = query.getType();
            if (qtype == 0 && query.getLeft() != null) {
                qtype = query.getLeft().getType();
            }
            String sel = this.queryWhere(query);
            if (log.isDebugEnabled()) {
                log.debug((Object)sel);
            }
            Criteria critere = new Criteria();
            critere.addSql(sel);
            ReportQueryByCriteria report = qtype == 2 ? new ReportQueryByCriteria(OJBCurrentStep.class, critere, true) : new ReportQueryByCriteria(OJBHistoryStep.class, critere, true);
            report.setColumns(new String[]{"entryId"});
            Iterator iter = broker.getReportQueryIteratorByQuery((Query)report);
            while (iter.hasNext()) {
                Object[] obj = (Object[])iter.next();
                BigDecimal entryId = (BigDecimal)obj[0];
                results.add(new Long(entryId.longValue()));
            }
        }
        return results;
    }

    private PersistenceBroker getBroker() throws PBFactoryException {
        PersistenceBroker broker = PersistenceBrokerFactory.defaultPersistenceBroker();
        return broker;
    }

    private static String escape(String s) {
        StringBuffer sb = new StringBuffer(s);
        char[] chars = s.toCharArray();
        block4: for (int i = 0; i < chars.length; ++i) {
            char c = chars[i];
            switch (c) {
                case '\'': {
                    sb.insert(i, '\'');
                    ++i;
                    continue block4;
                }
                case '\\': {
                    sb.insert(i, '\\');
                    ++i;
                }
            }
        }
        return sb.toString();
    }

    private String queryComparison(WorkflowQuery query) {
        String left;
        String oper;
        Object value = query.getValue();
        int operator = query.getOperator();
        int field = query.getField();
        switch (operator) {
            case 1: {
                oper = " = ";
                break;
            }
            case 5: {
                oper = " <> ";
                break;
            }
            case 3: {
                oper = " > ";
                break;
            }
            case 2: {
                oper = " < ";
                break;
            }
            default: {
                oper = " = ";
            }
        }
        switch (field) {
            case 4: {
                left = "ACTION_ID";
                break;
            }
            case 6: {
                left = "CALLER";
                break;
            }
            case 3: {
                left = "FINISH_DATE";
                break;
            }
            case 1: {
                left = "OWNER";
                break;
            }
            case 2: {
                left = "START_DATE";
                break;
            }
            case 5: {
                left = "STEP_ID";
                break;
            }
            case 7: {
                left = "STATUS";
                break;
            }
            default: {
                left = "1";
            }
        }
        String right = value != null ? "'" + OJBWorkflowStore.escape(value.toString()) + "'" : "null";
        return left + oper + right;
    }

    private String queryWhere(WorkflowQuery query) {
        if (query.getLeft() == null) {
            return this.queryComparison(query);
        }
        int operator = query.getOperator();
        WorkflowQuery left = query.getLeft();
        WorkflowQuery right = query.getRight();
        switch (operator) {
            case 6: {
                return "(" + this.queryWhere(left) + " AND " + this.queryWhere(right) + ")";
            }
            case 7: {
                return "(" + this.queryWhere(left) + " OR " + this.queryWhere(right) + ")";
            }
            case 8: {
                return "(" + this.queryWhere(left) + " XOR " + this.queryWhere(right) + ")";
            }
        }
        return "";
    }
}

