/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.workflow.loader;

import com.opensymphony.workflow.InvalidWorkflowDescriptorException;
import com.opensymphony.workflow.loader.DescriptorFactory;
import com.opensymphony.workflow.loader.SecureDTDEntityResolver;
import com.opensymphony.workflow.loader.WorkflowDescriptor;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class WorkflowLoader {
    public static WorkflowDescriptor load(InputStream is) throws SAXException, IOException, InvalidWorkflowDescriptorException {
        return WorkflowLoader.load(is, null, true);
    }

    public static WorkflowDescriptor load(InputStream is, boolean validate) throws SAXException, IOException, InvalidWorkflowDescriptorException {
        return WorkflowLoader.load(is, null, validate);
    }

    public static WorkflowDescriptor load(URL url, boolean validate) throws SAXException, IOException, InvalidWorkflowDescriptorException {
        return WorkflowLoader.load(url.openStream(), url, validate);
    }

    private static WorkflowDescriptor load(InputStream is, URL url, boolean validate) throws SAXException, IOException, InvalidWorkflowDescriptorException {
        DocumentBuilder db;
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setNamespaceAware(true);
        dbf.setValidating(validate);
        try {
            dbf.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
            db = dbf.newDocumentBuilder();
            db.setEntityResolver(new SecureDTDEntityResolver());
        }
        catch (ParserConfigurationException e) {
            throw new SAXException("Error creating document builder", e);
        }
        db.setErrorHandler(new WorkflowErrorHandler(url));
        Document doc = db.parse(is);
        Element root = (Element)doc.getElementsByTagName("workflow").item(0);
        WorkflowDescriptor descriptor = DescriptorFactory.getFactory().createWorkflowDescriptor(root);
        if (validate) {
            descriptor.validate();
        }
        return descriptor;
    }

    public static class WorkflowErrorHandler
    implements ErrorHandler {
        private URL url;

        public WorkflowErrorHandler(URL url) {
            this.url = url;
        }

        @Override
        public void error(SAXParseException exception) throws SAXException {
            throw new SAXException(this.getMessage(exception));
        }

        @Override
        public void fatalError(SAXParseException exception) throws SAXException {
            throw new SAXException(this.getMessage(exception));
        }

        @Override
        public void warning(SAXParseException exception) throws SAXException {
        }

        private String getMessage(SAXParseException exception) {
            return exception.getMessage() + " (" + (this.url != null ? " url=" + this.url + ' ' : "") + "line:" + exception.getLineNumber() + (exception.getColumnNumber() > -1 ? " col:" + exception.getColumnNumber() : "") + ')';
        }
    }

    public static class AllExceptionsErrorHandler
    implements ErrorHandler {
        private final List exceptions = new ArrayList();

        public List getExceptions() {
            return this.exceptions;
        }

        @Override
        public void error(SAXParseException exception) {
            this.addMessage(exception);
        }

        @Override
        public void fatalError(SAXParseException exception) {
            this.addMessage(exception);
        }

        @Override
        public void warning(SAXParseException exception) {
        }

        private void addMessage(SAXParseException exception) {
            this.exceptions.add(exception.getMessage() + " (line:" + exception.getLineNumber() + (exception.getColumnNumber() > -1 ? " col:" + exception.getColumnNumber() : "") + ')');
        }
    }
}

