/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.workflow.loader;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class SecureDTDEntityResolver
implements EntityResolver {
    @Override
    public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
        if (systemId == null) {
            return this.failure();
        }
        try {
            URL url = new URL(systemId);
            String file = url.getFile();
            if (file != null && file.indexOf(47) > -1) {
                file = file.substring(file.lastIndexOf(47) + 1);
            }
            if (this.isOpenSymphonyUrl(url) && this.isDtdReference(systemId)) {
                return this.localDtd(file);
            }
        }
        catch (MalformedURLException e) {
            return this.localDtd(systemId);
        }
        return this.failure();
    }

    private boolean isDtdReference(String systemId) {
        return systemId.endsWith(".dtd");
    }

    private boolean isOpenSymphonyUrl(URL url) {
        return "www.opensymphony.com".equals(url.getHost());
    }

    private InputSource failure() {
        return new InputSource();
    }

    private InputSource localDtd(String fileName) {
        InputStream is = this.getClass().getResourceAsStream("/META-INF/" + fileName);
        if (is == null) {
            is = this.getClass().getResourceAsStream('/' + fileName);
        }
        if (is != null) {
            return new InputSource(is);
        }
        return this.failure();
    }
}

