/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.workflow.loader;

import com.opensymphony.workflow.loader.AbstractDescriptor;
import com.opensymphony.workflow.loader.RestrictionDescriptor;
import com.opensymphony.workflow.loader.XMLUtil;
import java.io.PrintWriter;
import org.w3c.dom.Element;

public class PermissionDescriptor
extends AbstractDescriptor {
    protected RestrictionDescriptor restriction;
    protected String name;

    PermissionDescriptor() {
    }

    PermissionDescriptor(Element permission) {
        this.init(permission);
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void setRestriction(RestrictionDescriptor restriction) {
        this.restriction = restriction;
    }

    public RestrictionDescriptor getRestriction() {
        return this.restriction;
    }

    @Override
    public void writeXML(PrintWriter out, int indent) {
        XMLUtil.printIndent(out, indent++);
        out.print("<permission ");
        if (this.hasId()) {
            out.print("id=\"" + this.getId() + "\" ");
        }
        out.println("name=\"" + this.name + "\">");
        this.restriction.writeXML(out, indent);
        XMLUtil.printIndent(out, --indent);
        out.println("</permission>");
    }

    protected void init(Element permission) {
        this.name = permission.getAttribute("name");
        try {
            this.setId(Integer.parseInt(permission.getAttribute("id")));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        this.restriction = new RestrictionDescriptor(XMLUtil.getChildElement(permission, "restrict-to"));
    }
}

