/*
 * Decompiled with CFR 0.152.
 */
package com.nimbusds.jose.crypto;

import com.nimbusds.jose.EncryptionMethod;
import com.nimbusds.jose.JOSEException;
import com.nimbusds.jose.JWEAlgorithm;
import com.nimbusds.jose.JWEDecrypter;
import com.nimbusds.jose.JWEHeader;
import com.nimbusds.jose.crypto.AES;
import com.nimbusds.jose.crypto.AESCBC;
import com.nimbusds.jose.crypto.AESGCM;
import com.nimbusds.jose.crypto.CriticalHeaderParameterChecker;
import com.nimbusds.jose.crypto.DeflateHelper;
import com.nimbusds.jose.crypto.RSA1_5;
import com.nimbusds.jose.crypto.RSACryptoProvider;
import com.nimbusds.jose.crypto.RSA_OAEP;
import com.nimbusds.jose.crypto.RSA_OAEP_256;
import com.nimbusds.jose.util.Base64URL;
import com.nimbusds.jose.util.StringUtils;
import java.security.SecureRandom;
import java.security.interfaces.RSAPrivateKey;
import java.util.HashSet;
import java.util.Set;
import javax.crypto.SecretKey;
import net.jcip.annotations.ThreadSafe;

@ThreadSafe
public class RSADecrypter
extends RSACryptoProvider
implements JWEDecrypter {
    private Set<JWEAlgorithm> acceptedAlgs = new HashSet<JWEAlgorithm>(this.supportedAlgorithms());
    private Set<EncryptionMethod> acceptedEncs = new HashSet<EncryptionMethod>(this.supportedEncryptionMethods());
    private final CriticalHeaderParameterChecker critParamChecker = new CriticalHeaderParameterChecker();
    private final RSAPrivateKey privateKey;

    public RSADecrypter(RSAPrivateKey privateKey) {
        if (privateKey == null) {
            throw new IllegalArgumentException("The private RSA key must not be null");
        }
        this.privateKey = privateKey;
    }

    public RSAPrivateKey getPrivateKey() {
        return this.privateKey;
    }

    @Override
    public Set<JWEAlgorithm> getAcceptedAlgorithms() {
        return this.acceptedAlgs;
    }

    @Override
    public void setAcceptedAlgorithms(Set<JWEAlgorithm> acceptedAlgs) {
        if (acceptedAlgs == null) {
            throw new IllegalArgumentException("The accepted JWE algorithms must not be null");
        }
        if (!this.supportedAlgorithms().containsAll(acceptedAlgs)) {
            throw new IllegalArgumentException("Unsupported JWE algorithm(s)");
        }
        this.acceptedAlgs = acceptedAlgs;
    }

    @Override
    public Set<EncryptionMethod> getAcceptedEncryptionMethods() {
        return this.acceptedEncs;
    }

    @Override
    public void setAcceptedEncryptionMethods(Set<EncryptionMethod> acceptedEncs) {
        if (acceptedEncs == null) {
            throw new IllegalArgumentException("The accepted encryption methods must not be null");
        }
        if (!this.supportedEncryptionMethods().containsAll(acceptedEncs)) {
            throw new IllegalArgumentException("Unsupported encryption method(s)");
        }
        this.acceptedEncs = acceptedEncs;
    }

    @Override
    public Set<String> getIgnoredCriticalHeaderParameters() {
        return this.critParamChecker.getIgnoredCriticalHeaders();
    }

    @Override
    public void setIgnoredCriticalHeaderParameters(Set<String> headers) {
        this.critParamChecker.setIgnoredCriticalHeaders(headers);
    }

    @Override
    public byte[] decrypt(JWEHeader header, Base64URL encryptedKey, Base64URL iv, Base64URL cipherText, Base64URL authTag) throws JOSEException {
        byte[] plainText;
        SecretKey cek;
        if (encryptedKey == null) {
            throw new JOSEException("The encrypted key must not be null");
        }
        if (iv == null) {
            throw new JOSEException("The initialization vector (IV) must not be null");
        }
        if (authTag == null) {
            throw new JOSEException("The authentication tag must not be null");
        }
        if (!this.critParamChecker.headerPasses(header)) {
            throw new JOSEException("Unsupported critical header parameter");
        }
        JWEAlgorithm alg = header.getAlgorithm();
        if (alg.equals(JWEAlgorithm.RSA1_5)) {
            int keyLength = header.getEncryptionMethod().cekBitLength();
            SecureRandom randomGen = this.getSecureRandom();
            SecretKey randomCEK = AES.generateKey(keyLength, randomGen);
            try {
                cek = RSA1_5.decryptCEK(this.privateKey, encryptedKey.decode(), keyLength, this.keyEncryptionProvider);
                if (cek == null) {
                    cek = randomCEK;
                }
            }
            catch (Exception e) {
                cek = randomCEK;
            }
        } else if (alg.equals(JWEAlgorithm.RSA_OAEP)) {
            cek = RSA_OAEP.decryptCEK(this.privateKey, encryptedKey.decode(), this.keyEncryptionProvider);
        } else if (alg.equals(JWEAlgorithm.RSA_OAEP_256)) {
            cek = RSA_OAEP_256.decryptCEK(this.privateKey, encryptedKey.decode(), this.keyEncryptionProvider);
        } else {
            throw new JOSEException("Unsupported JWE algorithm, must be RSA1_5 or RSA_OAEP");
        }
        byte[] aad = StringUtils.toByteArray(header.toBase64URL().toString());
        EncryptionMethod enc = header.getEncryptionMethod();
        if (enc.equals(EncryptionMethod.A128CBC_HS256) || enc.equals(EncryptionMethod.A192CBC_HS384) || enc.equals(EncryptionMethod.A256CBC_HS512)) {
            plainText = AESCBC.decryptAuthenticated(cek, iv.decode(), cipherText.decode(), aad, authTag.decode(), this.contentEncryptionProvider, this.macProvider);
        } else if (enc.equals(EncryptionMethod.A128GCM) || enc.equals(EncryptionMethod.A192GCM) || enc.equals(EncryptionMethod.A256GCM)) {
            plainText = AESGCM.decrypt(cek, iv.decode(), cipherText.decode(), aad, authTag.decode(), this.contentEncryptionProvider);
        } else if (enc.equals(EncryptionMethod.A128CBC_HS256_DEPRECATED) || enc.equals(EncryptionMethod.A256CBC_HS512_DEPRECATED)) {
            plainText = AESCBC.decryptWithConcatKDF(header, cek, encryptedKey, iv, cipherText, authTag, this.contentEncryptionProvider, this.macProvider);
        } else {
            throw new JOSEException("Unsupported encryption method, must be A128CBC_HS256, A192CBC_HS384, A256CBC_HS512, A128GCM, A192GCM or A256GCM");
        }
        return DeflateHelper.applyDecompression(header, plainText);
    }
}

