/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.queryParser;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.CachingTokenFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.apache.lucene.analysis.tokenattributes.PositionIncrementAttribute;
import org.apache.lucene.index.Term;
import org.apache.lucene.queryParser.CharStream;
import org.apache.lucene.queryParser.ParseException;
import org.apache.lucene.queryParser.QueryParser;
import org.apache.lucene.queryParser.QueryParserTokenManager;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.MultiPhraseQuery;
import org.apache.lucene.search.PhraseQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.util.Version;

public class ExtendedQueryParser
extends QueryParser {
    public ExtendedQueryParser(Version matchVersion, String f, Analyzer a) {
        super(matchVersion, f, a);
    }

    protected ExtendedQueryParser(CharStream stream) {
        super(stream);
    }

    protected ExtendedQueryParser(QueryParserTokenManager tm) {
        super(tm);
    }

    protected Query getFieldQuery(String field, String queryText, boolean quoted) throws ParseException {
        return this.newFieldQuery(this.analyzer, field, queryText, quoted);
    }

    protected Query newFieldQuery(Analyzer analyzer, String field, String queryText, boolean quoted) throws ParseException {
        TokenStream source;
        try {
            source = analyzer.reusableTokenStream(field, (Reader)new StringReader(queryText));
            source.reset();
        }
        catch (IOException e) {
            source = analyzer.tokenStream(field, (Reader)new StringReader(queryText));
        }
        CachingTokenFilter buffer = new CachingTokenFilter(source);
        CharTermAttribute termAtt = null;
        PositionIncrementAttribute posIncrAtt = null;
        int numTokens = 0;
        boolean success = false;
        try {
            buffer.reset();
            success = true;
        }
        catch (IOException e) {
            // empty catch block
        }
        if (success) {
            if (buffer.hasAttribute(CharTermAttribute.class)) {
                termAtt = (CharTermAttribute)buffer.getAttribute(CharTermAttribute.class);
            }
            if (buffer.hasAttribute(PositionIncrementAttribute.class)) {
                posIncrAtt = (PositionIncrementAttribute)buffer.getAttribute(PositionIncrementAttribute.class);
            }
        }
        int positionCount = 0;
        boolean severalTokensAtSamePosition = false;
        boolean hasMoreTokens = false;
        if (termAtt != null) {
            try {
                hasMoreTokens = buffer.incrementToken();
                while (hasMoreTokens) {
                    int positionIncrement;
                    ++numTokens;
                    int n = positionIncrement = posIncrAtt != null ? posIncrAtt.getPositionIncrement() : 1;
                    if (positionIncrement != 0) {
                        positionCount += positionIncrement;
                    } else {
                        severalTokensAtSamePosition = true;
                    }
                    hasMoreTokens = buffer.incrementToken();
                }
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        try {
            buffer.reset();
            source.close();
        }
        catch (IOException e) {
            // empty catch block
        }
        if (numTokens == 0) {
            return null;
        }
        if (numTokens == 1) {
            String term = null;
            try {
                boolean hasNext = buffer.incrementToken();
                assert (hasNext);
                term = termAtt.toString();
            }
            catch (IOException e) {
                // empty catch block
            }
            return this.newTermQuery(new Term(field, term));
        }
        if (severalTokensAtSamePosition || !quoted && !this.getAutoGeneratePhraseQueries()) {
            if (positionCount == 1 || !quoted && !this.getAutoGeneratePhraseQueries()) {
                BooleanQuery q = this.newBooleanQuery(positionCount == 1);
                BooleanClause.Occur occur = positionCount > 1 && this.getDefaultOperator() == AND_OPERATOR ? BooleanClause.Occur.MUST : BooleanClause.Occur.SHOULD;
                for (int i = 0; i < numTokens; ++i) {
                    String term = null;
                    try {
                        boolean hasNext = buffer.incrementToken();
                        assert (hasNext);
                        term = termAtt.toString();
                    }
                    catch (IOException e) {
                        // empty catch block
                    }
                    Query currentQuery = this.newTermQuery(new Term(field, term));
                    q.add(currentQuery, occur);
                }
                return q;
            }
            MultiPhraseQuery mpq = this.newMultiPhraseQuery();
            mpq.setSlop(this.phraseSlop);
            ArrayList<Term> multiTerms = new ArrayList<Term>();
            int position = -1;
            for (int i = 0; i < numTokens; ++i) {
                String term = null;
                int positionIncrement = 1;
                try {
                    boolean hasNext = buffer.incrementToken();
                    assert (hasNext);
                    term = termAtt.toString();
                    if (posIncrAtt != null) {
                        positionIncrement = posIncrAtt.getPositionIncrement();
                    }
                }
                catch (IOException e) {
                    // empty catch block
                }
                if (positionIncrement > 0 && multiTerms.size() > 0) {
                    if (this.enablePositionIncrements) {
                        mpq.add(multiTerms.toArray(new Term[0]), position);
                    } else {
                        mpq.add(multiTerms.toArray(new Term[0]));
                    }
                    multiTerms.clear();
                }
                position += positionIncrement;
                multiTerms.add(new Term(field, term));
            }
            if (this.enablePositionIncrements) {
                mpq.add(multiTerms.toArray(new Term[0]), position);
            } else {
                mpq.add(multiTerms.toArray(new Term[0]));
            }
            return mpq;
        }
        PhraseQuery pq = this.newPhraseQuery();
        pq.setSlop(this.phraseSlop);
        int position = -1;
        for (int i = 0; i < numTokens; ++i) {
            String term = null;
            int positionIncrement = 1;
            try {
                boolean hasNext = buffer.incrementToken();
                assert (hasNext);
                term = termAtt.toString();
                if (posIncrAtt != null) {
                    positionIncrement = posIncrAtt.getPositionIncrement();
                }
            }
            catch (IOException e) {
                // empty catch block
            }
            if (this.enablePositionIncrements) {
                pq.add(new Term(field, term), position += positionIncrement);
                continue;
            }
            pq.add(new Term(field, term));
        }
        return pq;
    }
}

