/*
 * Decompiled with CFR 0.152.
 */
package com.jcraft.jzlib;

import com.jcraft.jzlib.ZStream;
import com.jcraft.jzlib.ZStreamException;
import java.io.IOException;
import java.io.OutputStream;

public class ZOutputStream
extends OutputStream {
    protected ZStream z = new ZStream();
    protected int bufsize = 512;
    protected int flush = 0;
    protected byte[] buf = new byte[this.bufsize];
    protected byte[] buf1 = new byte[1];
    protected boolean compress;
    private OutputStream out;

    public ZOutputStream(OutputStream outputStream) {
        this.out = outputStream;
        this.z.inflateInit();
        this.compress = false;
    }

    public ZOutputStream(OutputStream outputStream, int n) {
        this.out = outputStream;
        this.z.deflateInit(n);
        this.compress = true;
    }

    public void write(int n) throws IOException {
        this.buf1[0] = (byte)n;
        this.write(this.buf1, 0, 1);
    }

    public void write(byte[] byArray, int n, int n2) throws IOException {
        if (n2 == 0) {
            return;
        }
        this.z.next_in = byArray;
        this.z.next_in_index = n;
        this.z.avail_in = n2;
        do {
            this.z.next_out = this.buf;
            this.z.next_out_index = 0;
            this.z.avail_out = this.bufsize;
            int n3 = this.compress ? this.z.deflate(this.flush) : this.z.inflate(this.flush);
            if (n3 != 0) {
                throw new ZStreamException((this.compress ? "de" : "in") + "flating: " + this.z.msg);
            }
            this.out.write(this.buf, 0, this.bufsize - this.z.avail_out);
        } while (this.z.avail_in > 0 || this.z.avail_out == 0);
    }

    public int getFlushMode() {
        return this.flush;
    }

    public void setFlushMode(int n) {
        this.flush = n;
    }

    public void finish() throws IOException {
        do {
            this.z.next_out = this.buf;
            this.z.next_out_index = 0;
            this.z.avail_out = this.bufsize;
            int n = this.compress ? this.z.deflate(4) : this.z.inflate(4);
            if (n != 1 && n != 0) {
                throw new ZStreamException((this.compress ? "de" : "in") + "flating: " + this.z.msg);
            }
            if (this.bufsize - this.z.avail_out <= 0) continue;
            this.out.write(this.buf, 0, this.bufsize - this.z.avail_out);
        } while (this.z.avail_in > 0 || this.z.avail_out == 0);
        try {
            this.flush();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void end() throws IOException {
        if (this.compress) {
            this.z.deflateEnd();
        } else {
            this.z.inflateEnd();
        }
        this.z.free();
        this.z = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        try {
            try {
                this.finish();
            }
            catch (IOException iOException) {
            }
            Object var3_2 = null;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.end();
            this.out.close();
            this.out = null;
            throw throwable;
        }
        this.end();
        this.out.close();
        this.out = null;
    }

    public long getTotalIn() {
        return this.z.total_in;
    }

    public long getTotalOut() {
        return this.z.total_out;
    }

    public void flush() throws IOException {
        this.out.flush();
    }
}

