/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.util;

import com.atlassian.jira.datetime.LocalDate;
import com.atlassian.jira.datetime.LocalDateFactory;
import java.util.Date;
import org.apache.lucene.util.NumericUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LuceneUtils {
    private static final Logger log = LoggerFactory.getLogger(LuceneUtils.class);
    private static final String LOCALDATE_MAX_VALUE = "99999999";

    private LuceneUtils() {
    }

    public static String localDateToString(LocalDate localDate) {
        if (localDate == null) {
            return LOCALDATE_MAX_VALUE;
        }
        return LocalDateFactory.toIsoBasic(localDate);
    }

    public static LocalDate stringToLocalDate(String indexValue) {
        if (indexValue == null || indexValue.equals(LOCALDATE_MAX_VALUE)) {
            return null;
        }
        return LocalDateFactory.fromIsoBasicFormat(indexValue);
    }

    public static String dateToString(Date date) {
        if (date == null) {
            return NumericUtils.longToPrefixCoded((long)Long.MAX_VALUE);
        }
        long seconds = date.getTime() / 1000L;
        return NumericUtils.longToPrefixCoded((long)seconds);
    }

    public static Date stringToDate(String s) {
        if (s != null) {
            long seconds = NumericUtils.prefixCodedToLong((String)s);
            if (seconds == Long.MAX_VALUE) {
                return null;
            }
            return new Date(seconds * 1000L);
        }
        return new Date();
    }
}

