/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.config;

import com.atlassian.annotations.PublicApi;
import com.atlassian.fugue.Option;
import com.atlassian.jira.exception.CreateException;
import com.atlassian.jira.exception.DataAccessException;
import com.atlassian.jira.exception.RemoveException;
import com.atlassian.jira.issue.IssueConstant;
import com.atlassian.jira.issue.issuetype.IssueType;
import com.atlassian.jira.issue.priority.Priority;
import com.atlassian.jira.issue.resolution.Resolution;
import com.atlassian.jira.issue.status.Status;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.lang.Pair;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.ofbiz.core.entity.GenericValue;

@PublicApi
public interface ConstantsManager {
    public static final String ALL_STANDARD_ISSUE_TYPES = "-2";
    public static final String ALL_SUB_TASK_ISSUE_TYPES = "-3";
    public static final String ALL_ISSUE_TYPES = "-4";
    public static final String PRIORITY_CONSTANT_TYPE = CONSTANT_TYPE.PRIORITY.getType();
    public static final String STATUS_CONSTANT_TYPE = CONSTANT_TYPE.STATUS.getType();
    public static final String RESOLUTION_CONSTANT_TYPE = CONSTANT_TYPE.RESOLUTION.getType();
    public static final String ISSUE_TYPE_CONSTANT_TYPE = CONSTANT_TYPE.ISSUE_TYPE.getType();

    @Nonnull
    public Collection<Priority> getPriorities();

    @Deprecated
    @Nonnull
    default public Collection<Priority> getPriorityObjects() {
        return this.getPriorities();
    }

    public Priority getPriorityObject(String var1);

    public String getPriorityName(String var1);

    public Priority getDefaultPriority();

    @Deprecated
    public Priority getDefaultPriorityObject();

    public void refreshPriorities();

    @Nonnull
    public Collection<Resolution> getResolutions();

    @Deprecated
    default public Collection<Resolution> getResolutionObjects() {
        return this.getResolutions();
    }

    public Resolution getResolution(String var1);

    @Deprecated
    default public Resolution getResolutionObject(String id) {
        return this.getResolution(id);
    }

    public void refreshResolutions();

    public IssueType getIssueType(String var1);

    @Deprecated
    default public IssueType getIssueTypeObject(String id) {
        return this.getIssueType(id);
    }

    public Collection<IssueType> getRegularIssueTypeObjects();

    public Collection<IssueType> getAllIssueTypeObjects();

    public List<String> getAllIssueTypeIds();

    @Nonnull
    public Collection<IssueType> getSubTaskIssueTypeObjects();

    public List<IssueType> getEditableSubTaskIssueTypes();

    public List<String> expandIssueTypeIds(Collection<String> var1);

    public void refreshIssueTypes();

    @Deprecated
    public IssueType insertIssueType(String var1, Long var2, String var3, String var4, String var5) throws CreateException;

    public IssueType insertIssueType(String var1, Long var2, String var3, String var4, Long var5) throws CreateException;

    public void validateCreateIssueType(String var1, String var2, String var3, String var4, ErrorCollection var5, String var6);

    public void validateCreateIssueTypeWithAvatar(String var1, String var2, String var3, String var4, ErrorCollection var5, String var6);

    @Deprecated
    public void updateIssueType(String var1, String var2, Long var3, String var4, String var5, String var6) throws DataAccessException;

    public void updateIssueType(String var1, String var2, Long var3, String var4, String var5, Long var6);

    public void removeIssueType(String var1) throws RemoveException;

    @Deprecated
    public void storeIssueTypes(List<GenericValue> var1) throws DataAccessException;

    public Status getStatus(String var1);

    @Deprecated
    default public Status getStatusObject(String id) {
        return this.getStatus(id);
    }

    public Collection<Status> getStatuses();

    @Deprecated
    default public Collection<Status> getStatusObjects() {
        return this.getStatuses();
    }

    public void refreshStatuses();

    public Status getStatusByName(String var1);

    public Status getStatusByNameIgnoreCase(String var1);

    public Status getStatusByTranslatedName(String var1);

    @Nullable
    public IssueConstant getConstantObject(String var1, String var2);

    @Nullable
    public Collection<? extends IssueConstant> getConstantObjects(String var1);

    @Nullable
    public List<IssueConstant> convertToConstantObjects(String var1, Collection<?> var2);

    @Nonnull
    public List<IssueConstant> getConstantsByIds(@Nonnull CONSTANT_TYPE var1, @Nonnull Collection<String> var2);

    public boolean constantExists(String var1, String var2);

    public IssueConstant getIssueConstantByName(String var1, String var2);

    public IssueConstant getConstantByNameIgnoreCase(String var1, String var2);

    public IssueConstant getIssueConstant(GenericValue var1);

    @Deprecated
    public void refresh();

    public Option<Pair<String, ErrorCollection.Reason>> validateName(String var1, Option<IssueType> var2);

    public void invalidateAll();

    public void invalidate(IssueConstant var1);

    public void recalculateIssueTypeSequencesAndStore(List<IssueType> var1);

    public void recalculatePrioritySequencesAndStore(List<Priority> var1);

    public void recalculateStatusSequencesAndStore(List<Status> var1);

    public void recalculateResolutionSequencesAndStore(List<Resolution> var1);

    public static enum CONSTANT_TYPE {
        PRIORITY("Priority"),
        STATUS("Status"),
        RESOLUTION("Resolution"),
        ISSUE_TYPE("IssueType");

        private final String type;

        private CONSTANT_TYPE(String type) {
            this.type = type;
        }

        public String getType() {
            return this.type;
        }

        public static CONSTANT_TYPE forType(@Nonnull String type) {
            for (CONSTANT_TYPE o : CONSTANT_TYPE.values()) {
                if (!type.equals(o.type)) continue;
                return o;
            }
            return null;
        }

        public static CONSTANT_TYPE forTypeCaseInsensitive(@Nonnull String type) {
            for (CONSTANT_TYPE o : CONSTANT_TYPE.values()) {
                if (!type.equalsIgnoreCase(o.type)) continue;
                return o;
            }
            return null;
        }
    }
}

