/*
 * Decompiled with CFR 0.152.
 */
package electric.xml.xpath;

import electric.util.lex.Lex;
import electric.xml.Node;
import electric.xml.NodeList;
import electric.xml.XPathException;
import electric.xml.xpath.AllAttributesNode;
import electric.xml.xpath.AllNode;
import electric.xml.xpath.AttributeNode;
import electric.xml.xpath.AttributePredicate;
import electric.xml.xpath.CurrentNode;
import electric.xml.xpath.IndexPredicate;
import electric.xml.xpath.NameNode;
import electric.xml.xpath.ParentNode;
import electric.xml.xpath.RootNode;
import electric.xml.xpath.TextPredicate;
import electric.xml.xpath.WildNode;
import java.io.IOException;

public final class XPathNodeFactory {
    public static synchronized NodeList newNodes(String xpath) throws XPathException {
        try {
            NodeList nodes = new NodeList();
            Lex lex = new Lex(xpath, "/", 19);
            if (lex.peek() == 47) {
                nodes.append(new RootNode());
                lex.read();
            }
            if (!lex.eof()) {
                String token = lex.readToken();
                nodes.append(XPathNodeFactory.newNode(token));
                while (!lex.eof()) {
                    if (!token.equals("/")) {
                        lex.readChar(47);
                    }
                    token = lex.readToken();
                    nodes.append(XPathNodeFactory.newNode(token));
                }
            }
            return nodes;
        }
        catch (IOException exception) {
            throw new XPathException(exception.toString());
        }
    }

    private static Node newNode(String string) throws XPathException {
        if (string.equals("..")) {
            return new ParentNode();
        }
        if (string.equals(".")) {
            return new CurrentNode();
        }
        if (string.equals("/")) {
            return new WildNode();
        }
        if (string.equals("*")) {
            return new AllNode();
        }
        if (string.equals("@*")) {
            return new AllAttributesNode();
        }
        if (string.startsWith("@")) {
            return new AttributeNode(string);
        }
        if (string.indexOf("[@") != -1) {
            return new AttributePredicate(string);
        }
        if (string.indexOf("[text") != -1) {
            return new TextPredicate(string);
        }
        if (string.indexOf("[") != -1) {
            return new IndexPredicate(string);
        }
        return new NameNode(string);
    }
}

