/*
 * Decompiled with CFR 0.152.
 */
package electric.xml.io.tools;

import electric.util.XURL;
import electric.util.classloader.ClassLoaders;
import electric.util.command.Commands;
import electric.util.file.FileUtil;
import electric.util.io.Streams;
import electric.util.jar.Jar;
import electric.util.java.JavaSource;
import electric.util.product.Product;
import electric.util.string.Strings;
import electric.util.tool.ToolUtil;
import electric.xml.Document;
import electric.xml.Element;
import electric.xml.ParseException;
import electric.xml.io.Mappings;
import electric.xml.io.Namespaces;
import electric.xml.io.Type;
import electric.xml.io.array.ArrayType;
import electric.xml.io.mapping.ILoaderConstants;
import electric.xml.io.schema.Schema;
import electric.xml.io.schema.SchemaProperties;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Date;
import java.util.Enumeration;

public class Schema2Java
implements ILoaderConstants {
    private static String url;
    private static String dir;
    private static String outputPath;
    private static String name;
    private static boolean generateAccessors;
    private static boolean verbose;
    static /* synthetic */ Class class$electric$xml$io$Type;

    public static void main(String[] args) {
        if (args.length == 0) {
            Schema2Java.printUsage();
            return;
        }
        try {
            Schema2Java.processArgs(args);
            Schema2Java.schema2java();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            Schema2Java.printUsage();
            System.exit(-1);
        }
    }

    private static void printUsage() {
        System.out.println("usage: schema2java [-Dname=value]* [-h] url+ [-d directory] [-i path] [-o dir/jar] [-p package] [-v] [-x cmdfile]");
        System.out.println();
        System.out.println("where:");
        System.out.println("  -Dname=value = set java system property");
        System.out.println("  url          = url of xml schema to process");
        System.out.println("  -d directory = output path for java files, '.' by default");
        System.out.println("  -g           = generate get/set methods");
        System.out.println("  -h           = print help and exit");
        System.out.println("  -i path      = input path for map files, '.' by default");
        System.out.println("  -o dir/jar   = output path for map files, '.' by default");
        System.out.println("  -p package   = package to place java code, none by default");
        System.out.println("  -v           = verbose");
        System.out.println("  -x cmdfile   = command file to execute");
        System.out.println();
        System.out.println("examples:");
        System.out.println();
        System.out.println("schema2java Book.xsd -p examples.serialization");
        System.out.println("  creates java files from Book.xsd, places them into examples.serialization package");
    }

    private static void processArgs(String[] args) throws Throwable {
        String mapPath = null;
        String defaultPackage = null;
        int i = 0;
        while (i < args.length) {
            String arg = args[i];
            if (!arg.startsWith("-")) {
                url = arg;
            } else {
                if (arg.length() == 1) {
                    throw new IllegalArgumentException("a plain - is not a valid argument");
                }
                switch (arg.charAt(1)) {
                    case 'd': {
                        dir = Strings.getString("d", args, ++i);
                        if (dir.endsWith("/") || dir.endsWith("\\")) break;
                        dir = dir + File.separator;
                        break;
                    }
                    case 'D': {
                        ToolUtil.setProperty(arg);
                        break;
                    }
                    case 'g': {
                        generateAccessors = true;
                        break;
                    }
                    case 'h': {
                        Schema2Java.printUsage();
                        System.exit(-1);
                    }
                    case 'i': {
                        mapPath = Strings.getString("i", args, ++i);
                        break;
                    }
                    case 'o': {
                        outputPath = Strings.getString("o", args, ++i);
                        break;
                    }
                    case 'p': {
                        defaultPackage = Strings.getString("p", args, ++i);
                        break;
                    }
                    case 'v': {
                        verbose = true;
                        break;
                    }
                    case 'x': {
                        String commandFile = Strings.getString("x", args, ++i);
                        Commands.execute(commandFile);
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("illegal argument " + arg.charAt(1));
                    }
                }
            }
            ++i;
        }
        if (url == null) {
            throw new IllegalArgumentException("missing URL");
        }
        name = Strings.head(Strings.tail(url, '/'), '.');
        File file = new File(outputPath, name + ".map");
        if (file.exists()) {
            file.delete();
        }
        Mappings.clear();
        if (defaultPackage == null) {
            defaultPackage = "";
        }
        Mappings.setDefaultPackage(defaultPackage);
        if (mapPath == null) {
            Mappings.readMappings();
        } else {
            Mappings.readMappings(mapPath);
        }
    }

    private static void schema2java() throws ParseException, IOException {
        Schema schema = Schema2Java.loadSchema(url);
        Document mappings = new Document();
        mappings.addComment(Schema2Java.getDescription());
        Element root = mappings.newRoot();
        root.setNamespace("map", SchemaProperties.getTmeMap());
        root.setName("map", "mappings");
        Enumeration types = schema.getNamespaces().getItems(class$electric$xml$io$Type == null ? (class$electric$xml$io$Type = Schema2Java.class$("electric.xml.io.Type")) : class$electric$xml$io$Type);
        while (types.hasMoreElements()) {
            Type type = (Type)types.nextElement();
            if (Mappings.getMapping(type.getNamespace(), type.getName()) != null || type.isStandard() || type.getName() == null) continue;
            if (type instanceof ArrayType) {
                type.appendSchema(root, true);
                continue;
            }
            if (!type.isInhibit()) {
                Schema2Java.writeDataStructure(type);
            }
            type.appendSchema(root, true);
        }
        if (root.hasChildren()) {
            String content = mappings.toString();
            if (outputPath.endsWith(".jar")) {
                Jar.saveFile(outputPath, name + ".map", content);
            } else {
                if (outputPath.length() > 0 && !outputPath.endsWith(ILoaderConstants.FILE_SEPARATOR)) {
                    outputPath = outputPath + ILoaderConstants.FILE_SEPARATOR;
                }
                FileUtil.saveFile(outputPath, name, mappings.toString(), ".map");
            }
        }
    }

    private static void writeDataStructure(Type type) throws IOException {
        if (type.getJavaName() == null) {
            return;
        }
        StringWriter stringWriter = new StringWriter();
        JavaSource source = new JavaSource();
        source.setGenerateAccessors(generateAccessors);
        PrintWriter printWriter = new PrintWriter(stringWriter);
        printWriter.println("// " + Schema2Java.getDescription());
        type.writeJava(source);
        source.write(printWriter);
        String filename = Strings.getLocalJavaName(type.getJavaName());
        FileUtil.saveFile(dir, filename, stringWriter.toString(), ".java");
    }

    public static Schema loadSchema(String path) throws IOException, ParseException {
        byte[] bytes = Schema2Java.loadResource(path);
        Document document = new Document(bytes);
        if (verbose) {
            System.out.println(document);
        }
        Element schema = document.getRoot();
        String version = schema.getNamespace();
        Namespaces namespaces = new Namespaces(version);
        return new Schema(namespaces, document.getRoot());
    }

    public static byte[] loadResource(String path) throws IOException {
        if (!XURL.hasProtocol(path)) {
            path = "file:/" + path;
        }
        InputStream stream = ClassLoaders.getInputStream(path);
        byte[] bytes = Streams.readFully(stream);
        return bytes;
    }

    private static String getDescription() {
        return "generated by " + Product.getShortDescription() + " (schema2java) on " + new Date();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        dir = "";
        outputPath = "";
        verbose = false;
    }
}

