/*
 * Decompiled with CFR 0.152.
 */
package electric.xml.io.simple;

import electric.util.Value;
import electric.util.array.ArrayUtil;
import electric.util.java.JavaSource;
import electric.util.log.ILoggingConstants;
import electric.util.log.Log;
import electric.util.string.Strings;
import electric.xml.Element;
import electric.xml.Elements;
import electric.xml.io.IReader;
import electric.xml.io.IWriter;
import electric.xml.io.Mappings;
import electric.xml.io.Namespaces;
import electric.xml.io.Type;
import electric.xml.io.schema.Schema;
import electric.xml.io.schema.SchemaException;
import electric.xml.io.schema.SchemaProperties;
import electric.xml.io.simple.EnumerationUtil;
import electric.xml.io.simple.SimpleType;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Vector;

public final class Restriction
extends SimpleType {
    private static final Class[] ONE_STRING = new Class[]{class$java$lang$String == null ? (class$java$lang$String = Restriction.class$("java.lang.String")) : class$java$lang$String};
    private boolean readSchema;
    private SimpleType baseType;
    private String baseQName;
    private boolean resolvedBaseType;
    int minLength = -1;
    boolean minLengthFixed;
    int maxLength = -1;
    boolean maxLengthFixed;
    int length = -1;
    boolean lengthFixed;
    String maxExclusive;
    boolean maxExclusiveFixed;
    String maxInclusive;
    boolean maxInclusiveFixed;
    String minExclusive;
    boolean minExclusiveFixed;
    String minInclusive;
    boolean minInclusiveFixed;
    String whiteSpace;
    boolean whiteSpaceFixed;
    int totalDigits = -1;
    boolean totalDigitsFixed;
    int fractionDigits = -1;
    boolean fractionDigitsFixed;
    String[] pattern;
    String[] enumerations;
    static /* synthetic */ Class class$java$lang$String;

    public Restriction() {
    }

    public Restriction(Namespaces namespaces, String namespace, String name, Class javaClass) throws SchemaException {
        this.setSchema(namespaces.findSchema(namespace));
        this.setName(name);
        this.setJavaClass(javaClass);
        this.setEnumerationFacet();
    }

    public Restriction(Namespaces namespaces, String namespace, String name, Element schema) throws SchemaException {
        this.setSchema(namespaces.findSchema(namespace));
        this.setName(name);
        this.readSchema(schema);
    }

    public Restriction(Schema schemaObject, String name, Element schemaElement) throws SchemaException {
        this.setSchema(schemaObject);
        this.setName(name);
        this.javaName = Mappings.getJavaName(schemaObject.getTargetNamespace(), name);
        if (this.javaName == null) {
            this.javaName = name;
        }
        this.readSchema(schemaElement);
    }

    public String toString() {
        return "Restriction( " + this.getQName() + ", base=" + this.baseQName + " )";
    }

    public boolean isMultiReference() {
        try {
            return this.getBaseType().isMultiReference();
        }
        catch (SchemaException exception) {
            return false;
        }
    }

    public synchronized SimpleType getBaseType() throws SchemaException {
        if (this.resolvedBaseType) {
            return this.baseType;
        }
        this.resolvedBaseType = true;
        if (this.readSchema) {
            if (this.baseQName != null) {
                this.baseType = (SimpleType)this.getNamespaces().getTypeWithQName(this.baseQName);
            }
        } else if (EnumerationUtil.isEnumeration(this.getJavaClass())) {
            try {
                Method method = this.getJavaClass().getMethod("getValue", null);
                this.baseType = (SimpleType)this.getNamespaces().getTypeWithJavaClass(method.getReturnType());
                this.setFacets();
            }
            catch (NoSuchMethodException exception) {
                throw new SchemaException("could not determine base type of enum " + this.getJavaClass());
            }
        }
        return this.baseType;
    }

    private void setFacets() throws SchemaException {
        if (EnumerationUtil.isEnumeration(super.getJavaClass())) {
            this.setEnumerationFacet();
        }
    }

    private void setEnumerationFacet() throws SchemaException {
        this.enumerations = new String[0];
        Field[] fields = this.getJavaClass().getFields();
        int i = 0;
        while (i < fields.length) {
            Field field = fields[i];
            if (field.getName().startsWith("_")) {
                try {
                    Object value = field.get(null);
                    this.enumerations = (String[])ArrayUtil.addElement(this.enumerations, value.toString());
                }
                catch (IllegalAccessException exception) {
                    throw new SchemaException(exception.toString());
                }
            }
            ++i;
        }
    }

    public void addDependencies(Vector dependencies) throws SchemaException {
        dependencies.addElement(this.getBaseType());
    }

    public String getJavaName() throws SchemaException {
        if (this.enumerations != null) {
            return super.getJavaName();
        }
        return this.getBaseType().getJavaName();
    }

    public Class getJavaClass() throws SchemaException {
        if (this.enumerations != null) {
            return super.getJavaClass();
        }
        return this.getBaseType().getJavaClass();
    }

    public void writeJava(JavaSource source) throws SchemaException {
        if (this.enumerations != null) {
            this.writeEnumeration(source);
        }
    }

    private void writeEnumeration(JavaSource source) throws SchemaException {
        String javaName = this.getJavaName();
        String localName = Strings.getLocalJavaName(javaName);
        String packageName = Strings.getJavaPackage(javaName);
        EnumerationUtil.writeJava(source, localName, packageName, this.getBaseType().getJavaClass(), this.enumerations);
    }

    public Object getEnumerationValue(Object enumeration) throws IOException {
        try {
            Method getValue = this.getJavaClass().getMethod("getValue", null);
            return getValue.invoke(enumeration, null);
        }
        catch (Throwable exception) {
            if (Log.isLogging(ILoggingConstants.EXCEPTION_EVENT)) {
                Log.log(ILoggingConstants.EXCEPTION_EVENT, exception);
            }
            throw new IOException(exception.toString());
        }
    }

    public Object getEnumerationValue(String string) throws IOException {
        try {
            Method fromString = this.getJavaClass().getMethod("fromString", ONE_STRING);
            return fromString.invoke(null, string);
        }
        catch (Throwable exception) {
            throw new IOException(exception.toString());
        }
    }

    public void readSchema(Element schema) throws SchemaException {
        this.readSchema = true;
        String javaName = schema.getAttributeValue(SchemaProperties.getTmeMap(), "class");
        if (javaName != null) {
            this.setJavaName(javaName);
        }
        Element restriction = schema.getElement("restriction");
        this.baseQName = restriction.getAttributeValue("base");
        if (this.baseQName == null) {
            throw new SchemaException("restriction " + this.name + " is missing base");
        }
        this.baseQName = restriction.getQName(this.baseQName);
        this.enumerations = this.getFacetStringArray("enumeration", restriction);
        this.pattern = this.getFacetStringArray("pattern", restriction);
        this.maxExclusive = this.getFacetString("maxExclusive", restriction);
        this.minExclusive = this.getFacetString("minExclusive", restriction);
        this.maxInclusive = this.getFacetString("maxInclusive", restriction);
        this.minInclusive = this.getFacetString("minInclusive", restriction);
        this.whiteSpace = this.getFacetString("whiteSpace", restriction);
        this.maxLength = this.getFacetInt("maxLength", restriction);
        this.minLength = this.getFacetInt("minLength", restriction);
        this.length = this.getFacetInt("length", restriction);
        this.totalDigits = this.getFacetInt("totalDigits", restriction);
        this.fractionDigits = this.getFacetInt("fractionDigits", restriction);
        if (this.enumerations != null && javaName == null) {
            javaName = Mappings.getJavaName(this.schema.getTargetNamespace(), this.name);
            if (javaName == null) {
                javaName = this.name;
            }
            this.setJavaName(javaName);
        }
    }

    public void writeSchema(Element element) throws SchemaException {
        this.writeSchema(element, false);
    }

    public void writeSchema(Element element, boolean annotated) throws SchemaException {
        String xsdPrefix = Type.getXSDPrefix(element);
        Element simpleType = element.addElement(xsdPrefix, "simpleType");
        if (this.getName() != null) {
            simpleType.setAttribute("name", this.getName());
        }
        if (annotated && this.enumerations != null) {
            simpleType.setAttribute("map:class", this.getJavaName());
        }
        Element restriction = simpleType.addElement(xsdPrefix, "restriction");
        restriction.setAttribute("base", this.getBaseType().getName(restriction));
        this.writeFacet("enumeration", restriction, this.enumerations);
        this.writeFacet("pattern", restriction, this.pattern);
        this.writeFacet("maxExclusive", restriction, this.maxExclusive);
        this.writeFacet("minExclusive", restriction, this.minExclusive);
        this.writeFacet("maxInclusive", restriction, this.maxInclusive);
        this.writeFacet("minInclusive", restriction, this.minInclusive);
        this.writeFacet("whiteSpace", restriction, this.whiteSpace);
        this.writeFacet("maxLength", restriction, this.maxLength);
        this.writeFacet("minLength", restriction, this.minLength);
        this.writeFacet("length", restriction, this.length);
        this.writeFacet("totalDigits", restriction, this.totalDigits);
        this.writeFacet("fractionDigits", restriction, this.fractionDigits);
    }

    public void writeObject(IWriter writer, Object object) throws IOException {
        if (EnumerationUtil.isEnumeration(object.getClass())) {
            writer.writeText(this.getEnumerationValue(object).toString());
        } else {
            this.baseType.writeObject(writer, object);
            writer.writeType(this);
        }
    }

    public void readObject(IReader reader, Value value) throws IOException {
        String string = reader.readText();
        if (this.enumerations != null) {
            value.setObject(this.getEnumerationValue(string));
        } else {
            this.getBaseType().readObject(reader, value);
        }
    }

    private int getFacetInt(String facetName, Element restriction) throws SchemaException {
        int facetValue = -1;
        Elements facetElements = restriction.getElements(facetName);
        if (facetElements.hasMoreElements()) {
            facetValue = Integer.parseInt(facetElements.next().getAttributeValue("value"));
            if (facetValue < 1) {
                throw new SchemaException(facetName + " in restriction " + this.getQName() + " is invalid.");
            }
            if (facetElements.hasMoreElements()) {
                throw new SchemaException("more than one " + facetName + " in restriction " + this.getName());
            }
        }
        return facetValue;
    }

    public boolean isInhibit() {
        return this.enumerations == null;
    }

    private String getFacetString(String facetName, Element restriction) throws SchemaException {
        String facetValue = null;
        Elements facetElements = restriction.getElements(facetName);
        if (facetElements.hasMoreElements()) {
            facetValue = facetElements.next().getAttributeValue("value");
            if (facetValue.length() < 1) {
                throw new SchemaException(facetName + " in restriction " + this.getName() + " is invalid.");
            }
            if (facetElements.hasMoreElements()) {
                throw new SchemaException("more than one " + facetName + " in restriction " + this.getName());
            }
        }
        return facetValue;
    }

    private String[] getFacetStringArray(String facetName, Element restriction) {
        String[] facetValue = null;
        Elements facetElements = restriction.getElements(facetName);
        if (facetElements.hasMoreElements()) {
            facetValue = new String[]{};
            while (facetElements.hasMoreElements()) {
                String value = facetElements.next().getAttributeValue("value");
                facetValue = (String[])ArrayUtil.addElement(facetValue, value);
            }
        }
        return facetValue;
    }

    private void writeFacet(String name, Element restriction, String value) {
        if (value == null) {
            return;
        }
        String xsdPrefix = Type.getXSDPrefix(restriction);
        Element facet = restriction.addElement(xsdPrefix, name);
        facet.setAttribute("value", value);
    }

    private void writeFacet(String name, Element restriction, String[] value) {
        if (value == null) {
            return;
        }
        String xsdPrefix = Type.getXSDPrefix(restriction);
        int i = 0;
        while (i < value.length) {
            Element facet = restriction.addElement(xsdPrefix, name);
            facet.setAttribute("value", value[i]);
            ++i;
        }
    }

    private void writeFacet(String name, Element restriction, int value) {
        if (value == -1) {
            return;
        }
        String xsdPrefix = Type.getXSDPrefix(restriction);
        Element facet = restriction.addElement(xsdPrefix, name);
        facet.setAttribute("value", "" + value);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

