/*
 * Decompiled with CFR 0.152.
 */
package electric.xml.io.mapping;

import electric.util.Context;
import electric.xml.Element;
import electric.xml.io.ITypeFactory;
import electric.xml.io.Mapping;
import electric.xml.io.Mappings;
import electric.xml.io.Namespaces;
import electric.xml.io.Type;
import electric.xml.io.schema.SchemaException;

public class MappingTypeFactory
implements ITypeFactory {
    private String encodingStyle = (String)Context.thread().getProperty("encodingStyle");

    public MappingTypeFactory() throws Exception {
        if (this.encodingStyle == null) {
            this.encodingStyle = "";
        }
    }

    public Type newType(Namespaces namespaces, Class javaClass) throws SchemaException {
        StringBuffer javaName = new StringBuffer();
        Class<?> componentClass = javaClass;
        Type type = null;
        while (componentClass.isArray()) {
            javaName.append("[]");
            componentClass = componentClass.getComponentType();
        }
        javaName.insert(0, componentClass.getName());
        Mapping mapping = Mappings.getMappingByEncoding(javaName.toString(), this.encodingStyle);
        if (mapping != null) {
            type = mapping.newType(namespaces);
            type.setJavaClass(javaClass);
        }
        return type;
    }

    public Type newType(Namespaces namespaces, String namespace, String name, Element schema) throws SchemaException {
        Mapping mapping = Mappings.getMapping(namespace, name, this.encodingStyle);
        Type type = null;
        if (mapping != null) {
            type = mapping.newType(namespaces);
        }
        return type;
    }

    public Type newType(Namespaces namespaces, String namespace, String name) throws SchemaException {
        Mapping mapping = Mappings.getMapping(namespace, name, namespaces.getEncodingStyle());
        Type type = null;
        if (mapping != null) {
            type = mapping.newType(namespaces);
        }
        return type;
    }
}

