/*
 * Decompiled with CFR 0.152.
 */
package electric.xml.io.mapping;

import electric.util.string.Strings;
import electric.xml.Document;
import electric.xml.Element;
import electric.xml.Elements;
import electric.xml.io.Mapping;
import electric.xml.io.Mappings;
import electric.xml.io.Namespaces;
import electric.xml.io.Type;
import electric.xml.io.array.ArrayType;
import electric.xml.io.mapping.ILoaderConstants;
import electric.xml.io.mapping.IMapConstants;
import electric.xml.io.model.IModel;
import electric.xml.io.schema.Schema;
import electric.xml.io.schema.SchemaException;

public final class MapFileParser
implements ILoaderConstants,
IMapConstants {
    static /* synthetic */ Class class$electric$xml$io$complex$ComplexType;

    public void parse(Document document) throws SchemaException {
        this.parse(document, null);
    }

    public void parse(Document document, String encodingStyle) throws SchemaException {
        if (document == null) {
            return;
        }
        Elements elements = document.getRoot().getElements();
        while (elements.hasMoreElements()) {
            Element element = elements.next();
            if (element.getName().equals("package")) {
                this.parsePackageMapping(element);
                continue;
            }
            if (element.getName().equals("default-package")) {
                this.parseDefaultPackageMapping(element);
                continue;
            }
            if (element.getName().equals("array-namespace")) {
                this.parseArrayNamespaceMapping(element);
                continue;
            }
            if (element.getName().equals("class")) {
                this.parseClassMapping(element, encodingStyle);
                continue;
            }
            if (!element.getName().equals("schema")) continue;
            MapFileParser.parseSchemaMappings(element, encodingStyle);
        }
    }

    private void parsePackageMapping(Element element) {
        String java = element.getAttributeValue("java");
        String namespace = element.getAttributeValue("namespace");
        Mappings.mapPackage(java, namespace);
    }

    private void parseDefaultPackageMapping(Element element) {
        String defaultPackage = element.getAttributeValue("java");
        Mappings.setDefaultPackage(defaultPackage);
    }

    private void parseArrayNamespaceMapping(Element element) {
        String namespace = element.getAttributeValue("namespace");
        String componentNamespace = element.getAttributeValue("componentNamespace");
        ArrayType.addArrayNamespace(componentNamespace, namespace);
    }

    private void parseClassMapping(Element element, String encodingStyle) {
        String type;
        String namespace;
        String java = element.getAttributeValue("java");
        String name = element.getAttributeValue("name");
        String dominant = element.getAttributeValue("dominant");
        if (name == null) {
            name = Strings.getLocalJavaName(java);
        }
        if ((namespace = element.getAttributeValue("namespace")) == null) {
            namespace = Mappings.getNamespace(Strings.getJavaPackage(java));
        }
        if ((type = element.getAttributeValue("type")) == null) {
            type = (class$electric$xml$io$complex$ComplexType == null ? (class$electric$xml$io$complex$ComplexType = MapFileParser.class$("electric.xml.io.complex.ComplexType")) : class$electric$xml$io$complex$ComplexType).getName();
        }
        Mappings.mapClass(java, namespace, name, type, Strings.getBoolean(dominant, false), encodingStyle);
    }

    private static synchronized void parseSchemaMappings(Element schemaElement, String encodingStyle) throws SchemaException {
        Schema schemaObject;
        Namespaces namespaces = Mappings.getNamespacesForEncoding(encodingStyle);
        String targetNamespace = schemaElement.getAttribute("targetNamespace");
        if (targetNamespace == null) {
            targetNamespace = "";
        }
        if ((schemaObject = namespaces.getSchema(targetNamespace)) == null) {
            schemaObject = new Schema(namespaces, schemaElement);
        } else {
            schemaObject.parseSchema(schemaElement);
        }
        Type[] types = schemaObject.getSchemaTypes();
        int i = 0;
        while (i < types.length) {
            if (!(types[i] instanceof IModel)) {
                Mappings.addMapping(new Mapping(types[i], encodingStyle));
            }
            ++i;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

