/*
 * Decompiled with CFR 0.152.
 */
package electric.xml.io.literal;

import electric.xml.Attribute;
import electric.xml.Document;
import electric.xml.Element;
import electric.xml.Text;
import electric.xml.io.IWriter;
import electric.xml.io.Namespaces;
import electric.xml.io.Type;
import electric.xml.io.complex.ComplexType;
import electric.xml.io.schema.ISchemaConstants;
import electric.xml.io.schema.SchemaAttribute;
import electric.xml.io.schema.SchemaElement;
import electric.xml.io.schema.SchemaException;
import electric.xml.io.schema.SchemaProperties;
import java.io.IOException;

public final class LiteralWriter
implements IWriter,
ISchemaConstants {
    public static boolean writeTypes = true;
    private static final String SMALL_PREFIX = "n";
    private Element element;
    private Namespaces namespaces;
    private boolean disableTypeOmissions;

    public LiteralWriter() {
        this.namespaces = new Namespaces(SchemaProperties.getDefaultSchema(), "");
    }

    public LiteralWriter(String name) {
        Document document = new Document();
        this.element = document.setRoot(name);
        this.namespaces = new Namespaces(SchemaProperties.getDefaultSchema(), "");
    }

    public LiteralWriter(String namespace, String name) {
        Document document = new Document();
        this.element = document.setRoot(SMALL_PREFIX, name, namespace);
        this.namespaces = new Namespaces(SchemaProperties.getDefaultSchema(), "");
    }

    public LiteralWriter(Element element) {
        this(element, new Namespaces(SchemaProperties.getDefaultSchema(), ""));
    }

    public LiteralWriter(Element element, Namespaces namespaces) {
        this(element, namespaces, false);
    }

    public LiteralWriter(Element element, Namespaces namespaces, boolean disableTypeOmissions) {
        this.element = element;
        this.namespaces = namespaces;
        this.disableTypeOmissions = disableTypeOmissions;
    }

    private LiteralWriter(Element element, LiteralWriter writer) {
        this.element = element;
        this.namespaces = writer.namespaces;
        this.disableTypeOmissions = writer.disableTypeOmissions;
    }

    public String getVersion() {
        return this.namespaces.getVersion();
    }

    public Document getDocument() {
        return this.element.getDocument();
    }

    public Element getElement() {
        return this.element;
    }

    public IWriter writeElement() {
        return new LiteralWriter(this.element.addElement(), this);
    }

    public IWriter writeElement(String name) {
        if (this.element == null) {
            this.element = new Document().setRoot(name);
            return this;
        }
        return new LiteralWriter(this.element.addElement(name), this);
    }

    public IWriter writeElement(String prefix, String name) {
        return new LiteralWriter(this.element.addElement(prefix, name), this);
    }

    public IWriter writeElement(Element newElement) {
        return new LiteralWriter(this.element.addElement(newElement), this);
    }

    public IWriter writeName(String name) {
        this.element.setName(name);
        return this;
    }

    public IWriter writeName(String prefix, String name) {
        this.element.setName(prefix, name);
        return this;
    }

    public IWriter writeAttribute(String name, String value) {
        this.element.setAttribute(name, value);
        return this;
    }

    public IWriter writeAttribute(String prefix, String name, String value) {
        this.element.setAttribute(prefix, name, value);
        return this;
    }

    public IWriter writeNamespace(String prefix, String value) {
        this.element.setNamespace(prefix, value);
        return this;
    }

    private String getXSIPrefix() {
        String xsiNamespace = this.getVersion() + "-instance";
        String prefix = this.element.getNamespacePrefix(xsiNamespace);
        if (prefix != null) {
            return prefix;
        }
        this.element.getRoot().setNamespace("xsi", xsiNamespace);
        this.element.getRoot().setNamespace("xsd", this.getVersion());
        return "xsi";
    }

    public static void setWriteTypes(boolean writeTypes) {
        LiteralWriter.writeTypes = writeTypes;
    }

    public static boolean getWriteTypes() {
        return writeTypes;
    }

    public IWriter writeType(Type type) throws IOException {
        if (writeTypes) {
            this.element.setAttribute(this.getXSIPrefix(), "type", type.getName(this.element));
        }
        return this;
    }

    public IWriter writeType(String type) throws IOException {
        if (writeTypes) {
            this.element.setAttribute(this.getXSIPrefix(), "type", type);
        }
        return this;
    }

    public Type getType(Class javaClass) throws SchemaException {
        return this.namespaces.getTypeWithJavaClass(javaClass);
    }

    public boolean getTypeOmissionDisabled() {
        return this.disableTypeOmissions;
    }

    public void setDisableTypeOmissions(boolean disableTypeOmissions) {
        this.disableTypeOmissions = disableTypeOmissions;
    }

    public void writeText(String value) {
        if (value != null) {
            this.element.addChild(new Text(value));
        }
    }

    public void writeBoolean(boolean value) {
        this.element.setBoolean(value);
    }

    public void writeBoolean(String name, boolean value) {
        this.element.addElement(name).setBoolean(value);
    }

    public void writeChar(char value) {
        this.element.setChar(value);
    }

    public void writeChar(String name, char value) {
        this.element.addElement(name).setChar(value);
    }

    public void writeByte(byte value) {
        this.element.setByte(value);
    }

    public void writeByte(String name, byte value) {
        this.element.addElement(name).setByte(value);
    }

    public void writeShort(short value) {
        this.element.setShort(value);
    }

    public void writeShort(String name, short value) {
        this.element.addElement(name).setShort(value);
    }

    public void writeInt(int value) {
        this.element.setInt(value);
    }

    public void writeInt(String name, int value) {
        this.element.addElement(name).setInt(value);
    }

    public void writeLong(long value) {
        this.element.setLong(value);
    }

    public void writeLong(String name, long value) {
        this.element.addElement(name).setLong(value);
    }

    public void writeFloat(float value) {
        this.element.setFloat(value);
    }

    public void writeFloat(String name, float value) {
        this.element.addElement(name).setFloat(value);
    }

    public void writeDouble(double value) {
        this.element.setDouble(value);
    }

    public void writeDouble(String name, double value) {
        this.element.addElement(name).setDouble(value);
    }

    public void writeString(String value) {
        this.writeString(this.element, value);
    }

    public void writeString(String name, String value) {
        this.writeString(this.element.addElement(name), value);
    }

    private void writeString(Element element, String value) {
        if (value != null) {
            element.addChild(new Text(value));
        }
    }

    public void writeNil() {
        this.element.setAttribute(this.getXSIPrefix(), "nil", "1");
    }

    public void writeObject(Object object) throws IOException {
        if (object == null) {
            this.writeNil();
        } else {
            Type type = this.getType(object.getClass());
            type.writeType(this);
            type.writeObject(this, object);
        }
    }

    public void writeObject(Object object, Type type) throws IOException {
        if (object == null) {
            this.writeNil();
        } else if (type instanceof ComplexType) {
            Type actualType = this.getType(object.getClass());
            this.write(object, actualType, type, this.disableTypeOmissions);
        } else {
            type.writeObject(this, object);
        }
    }

    private void write(Object object, Type actualType, Type formalType, boolean disableTypeOmission) throws IOException {
        if (!(actualType.useAnonymous() || !disableTypeOmission && actualType.equals(formalType))) {
            actualType.writeType(this);
        }
        actualType.writeObject(this, object);
    }

    public void writeObject(String name, Object object) throws IOException {
        this.writeElement(name).writeObject(object);
    }

    public void writeObject(String prefix, String name, Object object) throws IOException {
        this.writeElement(prefix, name).writeObject(object);
    }

    public void writeObject(String name, Object object, Type type) throws IOException {
        this.writeElement(name).writeObject(object, type);
    }

    public void writeObject(String prefix, String name, Object object, Type formalType) throws IOException {
        this.writeElement(prefix, name).writeObject(object, formalType);
    }

    public void writeObjectDisablingTypeOmission(String prefix, String name, Object object, Type formalType) throws IOException {
        LiteralWriter childWriter = new LiteralWriter(this.element.addElement(prefix, name), this);
        if (object == null) {
            childWriter.writeNil();
        } else {
            childWriter.write(object, formalType.getRuntimeType(object, this.namespaces), formalType, true);
        }
    }

    public void writeObjectDisablingTypeOmission(String name, Object object, Type formalType) throws IOException {
        LiteralWriter childWriter = new LiteralWriter(this.element.addElement(name), this);
        if (object == null) {
            childWriter.writeNil();
        } else {
            childWriter.write(object, formalType.getRuntimeType(object, this.namespaces), formalType, true);
        }
    }

    public void writeObject(SchemaAttribute attribute, Object object) throws IOException {
        attribute.writeObject(this, object);
        if (attribute.getSchema().getQualifyAttributes()) {
            String prefix = this.element.getPrefix(attribute.getSchema().getTargetNamespace());
            Attribute attrib = this.element.getAttributeObject(attribute.getName());
            if (attrib != null) {
                attrib.setPrefix(prefix);
            }
        }
    }

    public void writeObject(SchemaElement schemaElement, Object object) throws IOException {
        schemaElement.writeObject(this, object);
    }
}

