/*
 * Decompiled with CFR 0.152.
 */
package electric.xml.io.encoded;

import electric.util.dictionary.IdentityHashtable;
import electric.xml.Element;
import electric.xml.io.schema.ISchemaConstants;

final class Ids
implements ISchemaConstants {
    private Element root;
    private IdentityHashtable idToElement;
    private IdentityHashtable objectToItem;
    private boolean soap12refs = false;

    Ids(Element root, boolean soap12refs) {
        this.root = root;
        this.soap12refs = soap12refs;
    }

    Object getId(Object object) {
        if (this.objectToItem == null) {
            return null;
        }
        Object id = this.objectToItem.get(object);
        if (id == null || this.idToElement == null) {
            return null;
        }
        Element elementToPatch = (Element)this.idToElement.remove(id);
        if (elementToPatch == null) {
            return id;
        }
        String newId = "id" + id;
        if (this.root == null) {
            if (this.soap12refs) {
                elementToPatch.setAttribute("soapenc", "id", newId);
            } else {
                elementToPatch.setAttribute("id", newId);
            }
        } else {
            Element href = new Element(elementToPatch.getPrefix(), elementToPatch.getName(), elementToPatch.getNamespace());
            elementToPatch.replaceWith(href);
            String prefix = this.soap12refs ? href.getPrefix("http://www.w3.org/2003/05/soap-encoding", "soapenc") : href.getPrefix("http://schemas.xmlsoap.org/soap/encoding/", "soapenc");
            if (this.soap12refs) {
                href.setAttribute(prefix, "ref", "id" + id);
            } else {
                href.setAttribute("href", "#id" + id);
            }
            if (!this.soap12refs) {
                href.setAttribute(prefix, "root", "0");
            }
            if (this.soap12refs) {
                elementToPatch.setAttribute(prefix, "id", newId);
            } else {
                elementToPatch.setAttribute("id", newId);
            }
            elementToPatch.setName(null, newId);
            this.root.addElement(elementToPatch);
        }
        return id;
    }

    Object newId(Object object, Element elementToPatch) {
        if (this.objectToItem == null) {
            this.objectToItem = new IdentityHashtable();
        }
        Integer id = new Integer(this.objectToItem.size());
        this.objectToItem.put(object, id);
        if (this.idToElement == null) {
            this.idToElement = new IdentityHashtable();
        }
        this.idToElement.put(id, elementToPatch);
        return id;
    }

    void addId(Object object, Object id) {
        if (this.objectToItem == null) {
            this.objectToItem = new IdentityHashtable();
        }
        this.objectToItem.put(object, id);
    }
}

