/*
 * Decompiled with CFR 0.152.
 */
package electric.xml.io.elements;

import electric.util.Context;
import electric.util.license.Enabler;
import electric.util.log.ILoggingConstants;
import electric.util.log.Log;
import electric.xml.Element;
import electric.xml.io.ITypeFactory;
import electric.xml.io.Namespaces;
import electric.xml.io.Type;
import electric.xml.io.elements.ElementType;
import electric.xml.io.schema.ISchemaConstants;
import electric.xml.io.schema.SchemaException;

public class ElementTypeFactory
implements ITypeFactory,
ISchemaConstants {
    private static final Class ELEMENT_CLASS = class$electric$xml$Element == null ? (class$electric$xml$Element = ElementTypeFactory.class$("electric.xml.Element")) : class$electric$xml$Element;
    private String encodingStyle = (String)Context.thread().getProperty("encodingStyle");
    private static boolean enabled;
    private static boolean allowEnable;
    static /* synthetic */ Class class$electric$xml$Element;

    public Type newType(Namespaces namespaces, Class javaClass) throws SchemaException {
        if (!ELEMENT_CLASS.equals(javaClass)) {
            return null;
        }
        if (!enabled || this.encodingStyle == null || this.encodingStyle.equals("http://schemas.xmlsoap.org/soap/encoding/")) {
            return this.getBase64Type(namespaces);
        }
        return new ElementType(namespaces.findSchema("http://exml/"));
    }

    public Type newType(Namespaces namespaces, String namespace, String name) throws SchemaException {
        if (namespace.equals("http://exml/") && name.equals("element")) {
            return this.getBase64Type(namespaces);
        }
        return null;
    }

    public Type newType(Namespaces namespaces, String namespace, String name, Element schema) throws SchemaException {
        if (namespace.equals("http://exml/") && name.equals("element")) {
            return this.getBase64Type(namespaces);
        }
        if (schema.hasAttribute("name")) {
            return null;
        }
        Element model = null;
        if (schema.hasElement("sequence")) {
            model = schema.getElement("sequence");
        }
        if (model == null) {
            return null;
        }
        if (model.getElements().size() == 1 && model.hasElement("any")) {
            if (enabled) {
                return new ElementType(namespaces.findSchema("http://exml/"));
            }
            throw new SchemaException("<any> is only supported in GLUE Professional.  Please upgrade your license.");
        }
        return null;
    }

    private Type getBase64Type(Namespaces namespaces) {
        electric.xml.io.documents.ElementType type = new electric.xml.io.documents.ElementType();
        type.setSchema(namespaces.findSchema("http://exml/"));
        type.setName("element");
        type.setJavaName((class$electric$xml$Element == null ? (class$electric$xml$Element = ElementTypeFactory.class$("electric.xml.Element")) : class$electric$xml$Element).getName());
        type.setDominant(true);
        return type;
    }

    public static void enable() {
        if (enabled) {
            return;
        }
        if (!allowEnable) {
            throw new IllegalStateException("Direct element serialization cannot be enabled once it is disabled");
        }
        enabled = Enabler.enable();
        if (!enabled && Log.isLogging(ILoggingConstants.WARNING_EVENT)) {
            Log.log(ILoggingConstants.WARNING_EVENT, (Object)"Direct element serialization could not be enabled");
        }
    }

    public static void disable() {
        enabled = false;
        allowEnable = false;
        Log.log(ILoggingConstants.WARNING_EVENT, (Object)"Direct element serialization is disabled");
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        allowEnable = true;
    }
}

