/*
 * Decompiled with CFR 0.152.
 */
package electric.xml.io.elements;

import electric.util.Value;
import electric.util.license.Enabler;
import electric.util.log.ILoggingConstants;
import electric.util.log.Log;
import electric.xml.Element;
import electric.xml.io.IReader;
import electric.xml.io.IWriter;
import electric.xml.io.Type;
import electric.xml.io.schema.Schema;
import electric.xml.io.schema.SchemaException;
import java.io.IOException;

public class ElementType
extends Type {
    private static boolean enabled;
    private static boolean allowEnable;
    static /* synthetic */ Class class$electric$xml$Element;

    public ElementType(Schema schema) {
        this.checkEnabled();
        this.setSchema(schema);
        this.setInhibit(true);
        this.setAnonymous(true);
        this.name = "";
    }

    public boolean isStandard() {
        return true;
    }

    public boolean useAnonymous() {
        return true;
    }

    public boolean isAnonymous() {
        return true;
    }

    public boolean isMultiReference() {
        return false;
    }

    public void readObject(IReader reader, Value value) throws IOException {
        this.checkEnabled();
        Element element = (Element)value.getObject();
        if (element != null) {
            return;
        }
        element = reader.getElement().getElements().size() == 1 ? reader.getElement().getElements().next() : reader.getElement();
        value.setObject(new Element(element));
    }

    public void writeObject(IWriter writer, Object object) throws IOException {
        this.checkEnabled();
        writer.writeElement(new Element((Element)object));
    }

    public void writeSchema(Element schema) throws SchemaException {
        this.checkEnabled();
        String xsdPrefix = Type.getXSDPrefix(schema);
        Element complexType = schema.addElement(xsdPrefix, "complexType");
        Element sequence = complexType.addElement(xsdPrefix, "sequence");
        sequence.addElement(xsdPrefix, "any");
    }

    public String getJavaName() {
        return (class$electric$xml$Element == null ? (class$electric$xml$Element = ElementType.class$("electric.xml.Element")) : class$electric$xml$Element).getName();
    }

    public Class getJavaClass() {
        return class$electric$xml$Element == null ? (class$electric$xml$Element = ElementType.class$("electric.xml.Element")) : class$electric$xml$Element;
    }

    public static void enable() {
        if (enabled) {
            return;
        }
        if (!allowEnable) {
            throw new IllegalStateException("Direct element serialization cannot be enabled once it is disabled");
        }
        enabled = Enabler.enable();
        if (!enabled && Log.isLogging(ILoggingConstants.WARNING_EVENT)) {
            Log.log(ILoggingConstants.WARNING_EVENT, (Object)"Direct element serialization could not be enabled");
        }
    }

    public static boolean isEnabled() {
        return enabled;
    }

    private void checkEnabled() {
        if (!enabled) {
            throw new IllegalStateException("Direct element serialization is disabled");
        }
    }

    public static void disable() {
        enabled = false;
        allowEnable = false;
        Log.log(ILoggingConstants.WARNING_EVENT, (Object)"Direct element serialization is disabled");
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        allowEnable = true;
    }
}

