/*
 * Decompiled with CFR 0.152.
 */
package electric.xml.io.complex.factories;

import electric.util.log.ILoggingConstants;
import electric.util.log.Log;
import electric.xml.IEXMLLoggingConstants;
import electric.xml.io.IReader;
import electric.xml.io.complex.ComplexType;
import electric.xml.io.complex.IFactory;
import java.io.IOException;

public class DefaultFactory
implements IFactory,
IEXMLLoggingConstants {
    private ComplexType complexType;

    public DefaultFactory(ComplexType complexType) {
        this.complexType = complexType;
    }

    public Object newInstance(IReader reader) throws IOException {
        try {
            Class javaClass = this.complexType.getJavaClassWithCheck();
            return javaClass.newInstance();
        }
        catch (ClassNotFoundException exception) {
            throw new IOException(exception.toString());
        }
        catch (Exception exception) {
            if (Log.isLogging(ILoggingConstants.EXCEPTION_EVENT)) {
                Log.log(ILoggingConstants.EXCEPTION_EVENT, (Throwable)exception);
            }
            throw new IOException("no argument constructor is missing. " + exception.toString());
        }
    }
}

