/*
 * Decompiled with CFR 0.152.
 */
package electric.xml.io.complex.any;

import electric.util.Value;
import electric.util.java.JavaNames;
import electric.util.java.JavaSource;
import electric.util.license.Enabler;
import electric.util.log.ILoggingConstants;
import electric.util.log.Log;
import electric.xml.Element;
import electric.xml.io.IReader;
import electric.xml.io.IWriter;
import electric.xml.io.Type;
import electric.xml.io.accessors.Accessor;
import electric.xml.io.accessors.IAccessible;
import electric.xml.io.accessors.UnboundAccessor;
import electric.xml.io.schema.ISchemaConstants;
import electric.xml.io.schema.SchemaException;
import electric.xml.io.schema.SchemaProperties;
import java.io.IOException;
import java.lang.reflect.Array;

public class AnyHandler
implements ISchemaConstants,
IAccessible {
    private static final Class ELEMENT_CLASS = class$electric$xml$Element == null ? (class$electric$xml$Element = AnyHandler.class$("electric.xml.Element")) : class$electric$xml$Element;
    private static final Class ELEMENT_ARRAY_CLASS = Array.newInstance(class$electric$xml$Element == null ? (class$electric$xml$Element = AnyHandler.class$("electric.xml.Element")) : class$electric$xml$Element, 0).getClass();
    private static String defaultType = "electric.xml.Element";
    private static boolean enabled;
    private static boolean allowEnable;
    Type parentType;
    String processContents;
    String namespace;
    int minOccurs = 0;
    int maxOccurs = 1;
    Accessor accessor;
    static /* synthetic */ Class class$electric$xml$Element;

    public AnyHandler(Element any, Type parentType) throws SchemaException {
        String max;
        this.checkEnabled();
        this.parentType = parentType;
        this.accessor = new UnboundAccessor(this, "anyReference", any);
        String min = any.getAttributeValue("minOccurs");
        if (min != null) {
            this.minOccurs = Integer.parseInt(min);
        }
        if ((max = any.getAttributeValue("maxOccurs")) != null) {
            this.maxOccurs = max.equals("unbounded") || max.equals("*") ? Integer.MAX_VALUE : Integer.parseInt(max);
        }
        this.processContents = any.getAttribute("processContents");
        this.namespace = any.getAttribute("namespace");
    }

    public void readObject(IReader reader, Value value) throws IOException {
        if (this.accessor.getJavaName().equals(JavaNames.getJavaName(ELEMENT_CLASS))) {
            this.readElement(reader, value);
        }
        if (this.accessor.getJavaName().equals(JavaNames.getJavaName(ELEMENT_ARRAY_CLASS))) {
            this.readElement(reader, value);
        }
    }

    private void readElement(IReader reader, Value value) throws IOException {
        Value newValue = new Value();
        Element[] elements = reader.getUnreadElements();
        if (this.maxOccurs > 1) {
            newValue.setObject(elements);
        } else {
            if (elements.length > 1) {
                throw new IOException("Too many elements.");
            }
            newValue.setObject(elements[0]);
        }
        try {
            this.accessor.set(value, newValue);
        }
        catch (IOException exception) {
            throw exception;
        }
        catch (Exception exception) {
            if (Log.isLogging(ILoggingConstants.EXCEPTION_EVENT)) {
                Log.log(ILoggingConstants.EXCEPTION_EVENT, (Throwable)exception);
            }
            throw new IOException(exception.toString());
        }
    }

    public void writeObject(IWriter writer, Object object) throws IOException {
        if (this.accessor.getJavaName().equals((class$electric$xml$Element == null ? (class$electric$xml$Element = AnyHandler.class$("electric.xml.Element")) : class$electric$xml$Element).getName())) {
            this.writeElement(writer, object);
        }
        if (this.accessor.getJavaName().equals((class$electric$xml$Element == null ? (class$electric$xml$Element = AnyHandler.class$("electric.xml.Element")) : class$electric$xml$Element).getName() + "[]")) {
            this.writeElement(writer, object);
        }
    }

    public void writeElement(IWriter writer, Object object) throws IOException {
        try {
            Object source = this.accessor.get(object);
            if (source instanceof Element) {
                Element element = (Element)source;
                writer.writeElement(new Element(element));
            }
            if (source instanceof Element[]) {
                Element[] array = (Element[])source;
                int i = 0;
                while (i < array.length) {
                    writer.writeElement(new Element(array[i]));
                    ++i;
                }
            }
        }
        catch (IOException exception) {
            throw exception;
        }
        catch (Exception exception) {
            if (Log.isLogging(ILoggingConstants.EXCEPTION_EVENT)) {
                Log.log(ILoggingConstants.EXCEPTION_EVENT, (Throwable)exception);
            }
            throw new IOException(exception.toString());
        }
    }

    public void writeJava(JavaSource source) throws SchemaException {
        this.accessor.writeJava(source);
    }

    public void writeSchema(Element schema, boolean annotated) throws SchemaException {
        String xsdPrefix = schema.getPrefix(SchemaProperties.getDefaultSchema(), "xsd");
        Element any = schema.addElement(xsdPrefix, "any");
        any.setAttribute("minOccurs", "" + this.minOccurs);
        if (this.minOccurs != 1) {
            any.setAttribute("minOccurs", Integer.toString(this.minOccurs));
        }
        if (this.maxOccurs == Integer.MAX_VALUE) {
            any.setAttribute("maxOccurs", "unbounded");
        } else if (this.maxOccurs != 1) {
            any.setAttribute("maxOccurs", Integer.toString(this.maxOccurs));
        }
        if (annotated && this.accessor != null) {
            this.accessor.annotateSchema(any);
        }
        if (this.namespace != null) {
            any.setAttribute("namespace", this.namespace);
        }
        if (this.processContents != null) {
            any.setAttribute("processContents", this.processContents);
        }
    }

    public Class getAccessibleJavaClass() throws SchemaException {
        return this.parentType.getJavaClass();
    }

    public String getAccessibleJavaName() throws SchemaException {
        if (this.maxOccurs == 1) {
            return defaultType;
        }
        return defaultType + "[]";
    }

    public static void enable() {
        if (enabled) {
            return;
        }
        if (!allowEnable) {
            throw new IllegalStateException("support for <any> wildcards cannot be enabled once it is disabled");
        }
        enabled = Enabler.enable();
        if (!enabled && Log.isLogging(ILoggingConstants.WARNING_EVENT)) {
            Log.log(ILoggingConstants.WARNING_EVENT, (Object)"support for <any> wildcards could not be enabled");
        }
    }

    public static boolean isEnabled() {
        return enabled;
    }

    private void checkEnabled() {
        if (!enabled) {
            throw new IllegalStateException("support for <any> wildcards is disabled");
        }
    }

    public static void disable() {
        enabled = false;
        allowEnable = false;
        Log.log(ILoggingConstants.WARNING_EVENT, (Object)"support for <any> wildcards is disabled");
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        allowEnable = true;
    }
}

