/*
 * Decompiled with CFR 0.152.
 */
package electric.xml.io.complex;

import electric.util.Value;
import electric.util.array.ArrayUtil;
import electric.util.java.JavaField;
import electric.util.java.JavaSource;
import electric.xml.Element;
import electric.xml.Elements;
import electric.xml.io.IReader;
import electric.xml.io.IWriter;
import electric.xml.io.Type;
import electric.xml.io.accessors.Accessor;
import electric.xml.io.accessors.FieldAccessor;
import electric.xml.io.accessors.IAccessible;
import electric.xml.io.complex.ComplexType;
import electric.xml.io.complex.any.AnyAttributeHandler;
import electric.xml.io.model.IModel;
import electric.xml.io.schema.SchemaAttribute;
import electric.xml.io.schema.SchemaElement;
import electric.xml.io.schema.SchemaException;
import electric.xml.io.schema.SchemaLocations;
import java.io.IOException;
import java.util.Vector;

public final class SimpleContent
extends Type
implements IAccessible,
IModel {
    private ComplexType complexType;
    private SchemaAttribute[] attributes = new SchemaAttribute[0];
    private Type baseType;
    private String baseQName;
    private Accessor accessor;
    private Element annotation;
    private AnyAttributeHandler anyAttributeHandler;

    public SimpleContent(ComplexType complexType, Element schema) throws SchemaException {
        this.complexType = complexType;
        this.setSchema(complexType.getSchema());
        this.readSchema(schema);
        this.accessor = new FieldAccessor(this, "value");
    }

    public synchronized Type getBaseType() throws SchemaException {
        if (this.baseType == null) {
            this.baseType = this.getNamespaces().getTypeWithQName(this.baseQName);
        }
        return this.baseType;
    }

    public void addAttribute(SchemaAttribute attribute) {
        this.attributes = (SchemaAttribute[])ArrayUtil.addElement(this.attributes, attribute);
    }

    public SchemaAttribute[] getAttributes() {
        return this.attributes;
    }

    public void addDependencies(Vector dependencies) throws SchemaException {
        int i = 0;
        while (i < this.attributes.length) {
            this.attributes[i].addDependencies(dependencies);
            ++i;
        }
        dependencies.addElement(this.getBaseType());
    }

    public SchemaElement getSchemaElement(String name) {
        return null;
    }

    public SchemaAttribute getSchemaAttribute(String name) {
        int i = 0;
        while (i < this.attributes.length) {
            if (this.attributes[i].getName().equals(name)) {
                return this.attributes[i];
            }
            ++i;
        }
        return null;
    }

    public void readSchema(Element schema) throws SchemaException {
        Element extension = schema.getElement("extension");
        if (extension != null) {
            this.readSchemaExtension(extension);
            return;
        }
        Element restriction = schema.getElement("restriction");
        if (restriction != null) {
            this.readSchemaRestriction(restriction);
            return;
        }
        throw new SchemaException("<simpleContent> in type " + this.complexType.getQName() + " must currently be followed by <extension> or <restriction>");
    }

    private void readSchemaExtension(Element extension) throws SchemaException {
        this.baseQName = extension.getAttributeValue("base");
        if (this.baseQName == null) {
            throw new SchemaException("<extension> in type " + this.complexType.getQName() + " must include base attribute");
        }
        this.baseQName = extension.getQName(this.baseQName);
        Elements elements = extension.getElements();
        while (elements.hasMoreElements()) {
            Element child = elements.next();
            if (child.getName().equals("annotation")) {
                this.annotation = new Element(child);
                continue;
            }
            if (child.getName().equals("anyAttribute")) {
                this.anyAttributeHandler = new AnyAttributeHandler(child, this);
                continue;
            }
            if (child.getName().equals("attribute")) {
                this.addAttribute(new SchemaAttribute(this.complexType, child));
                continue;
            }
            throw new SchemaException("<extension> in type " + this.complexType.getQName() + " must currently be followed by <annotation>, <anyAttribute> or <attribute>");
        }
    }

    private void readSchemaRestriction(Element restriction) throws SchemaException {
        this.baseQName = restriction.getAttributeValue("base");
        if (this.baseQName == null) {
            throw new SchemaException("<restriction> in type " + this.complexType.getQName() + " must include base attribute");
        }
        this.baseQName = restriction.getQName(this.baseQName);
        Elements elements = restriction.getElements();
        Element child = elements.first();
        if (child.getName().equals("annotation")) {
            this.annotation = new Element(child);
        } else if (child.getName().equals("anyAttribute")) {
            this.anyAttributeHandler = new AnyAttributeHandler(child, this);
        } else if (child.getName().equals("attribute")) {
            this.addAttribute(new SchemaAttribute(this.complexType, child));
        } else {
            throw new SchemaException("<restriction> in type " + this.complexType.getQName() + " must currently be followed by <annotation>, <anyAttribute> or <attribute>");
        }
    }

    public void writeSchema(Element element, boolean annotated) throws SchemaException {
        String xsdPrefix = Type.getXSDPrefix(element);
        if (!this.getBaseType().getNamespace().equals(this.getNamespace())) {
            SchemaLocations.appendImport(element.getParentElement(), this.getBaseType().getNamespace(), null);
        }
        Element simpleContent = element.addElement(xsdPrefix, "simpleContent");
        Element extension = simpleContent.addElement(xsdPrefix, "extension");
        extension.setAttribute("base", this.getBaseType().getName(extension));
        if (this.annotation != null) {
            extension.addElement(new Element(this.annotation));
        }
        int i = 0;
        while (i < this.attributes.length) {
            this.attributes[i].writeSchema(extension, annotated);
            ++i;
        }
        if (this.anyAttributeHandler != null) {
            this.anyAttributeHandler.writeSchema(extension, annotated);
        }
    }

    public Class getJavaClass() throws SchemaException {
        return this.complexType.getJavaClass();
    }

    public String getJavaName() throws SchemaException {
        return this.complexType.getJavaName();
    }

    public void writeJava(JavaSource source) throws SchemaException {
        source.addField(new JavaField("public", this.getBaseType().getJavaName(), "value", null));
        int i = 0;
        while (i < this.attributes.length) {
            this.attributes[i].writeJava(source);
            ++i;
        }
        if (this.anyAttributeHandler != null) {
            this.anyAttributeHandler.writeJava(source);
        }
    }

    public void forceResolution() {
        try {
            this.getBaseType();
        }
        catch (SchemaException exception) {}
    }

    public Class getAccessibleJavaClass() throws SchemaException {
        return this.complexType.getJavaClass();
    }

    public String getAccessibleJavaName() throws SchemaException {
        return this.complexType.getJavaName();
    }

    public void writeObject(IWriter writer, Object object) throws IOException {
        try {
            Object value = this.accessor.get(object);
            if (value != null) {
                writer.writeObject(value, this.getBaseType());
            }
            int i = 0;
            while (i < this.attributes.length) {
                writer.writeObject(this.attributes[i], object);
                ++i;
            }
            if (this.anyAttributeHandler != null) {
                this.anyAttributeHandler.writeObject(writer, object);
            }
            writer.writeType(this.complexType);
        }
        catch (IOException exception) {
            throw exception;
        }
        catch (Exception exception) {
            throw new IOException(exception.toString());
        }
    }

    public void readObject(IReader reader, Value value) throws IOException {
        try {
            Value v = new Value();
            this.getBaseType().readObject(reader, v);
            this.accessor.set(value, v);
            int i = 0;
            while (i < this.attributes.length) {
                this.attributes[i].readObject(reader, value);
                ++i;
            }
            if (this.anyAttributeHandler != null) {
                this.anyAttributeHandler.readObject(reader, value);
            }
        }
        catch (IOException exception) {
            throw exception;
        }
        catch (Exception exception) {
            throw new IOException(exception.toString());
        }
    }

    public Element getAnnotation() {
        return this.annotation;
    }

    public void setAnnotation(Element annotation) {
        this.annotation = annotation;
    }
}

