/*
 * Decompiled with CFR 0.152.
 */
package electric.xml.io.collections.sun;

import com.sun.java.util.collections.Hashtable;
import electric.util.Value;
import electric.xml.Element;
import electric.xml.io.IReader;
import electric.xml.io.IWriter;
import electric.xml.io.Type;
import electric.xml.io.collections.sun.CollectionType;
import electric.xml.io.schema.SchemaException;
import java.io.IOException;
import java.util.Enumeration;

public class HashtableType
extends CollectionType {
    public void writeSchema(Element schema) throws SchemaException {
        Type type = this.getType(CollectionType.OBJECT_ARRAY_CLASS);
        String xsdPrefix = Type.getXSDPrefix(schema);
        Element complexType = schema.addElement(xsdPrefix, "complexType");
        complexType.setAttribute("name", "SunHashtable");
        Element sequence = complexType.addElement(xsdPrefix, "sequence");
        Element keys = sequence.addElement(xsdPrefix, "element");
        keys.setAttribute("name", "keys");
        keys.setAttribute("type", Type.getName(type.getNamespace(), type.getName(), keys));
        Element values = sequence.addElement(xsdPrefix, "element");
        values.setAttribute("name", "values");
        values.setAttribute("type", Type.getName(type.getNamespace(), type.getName(), values));
    }

    public void writeObject(IWriter writer, Object object) throws IOException {
        Hashtable table = (Hashtable)object;
        Object[] keys = new Object[table.size()];
        Object[] values = new Object[table.size()];
        Enumeration keyEnum = table.keys();
        Enumeration valueEnum = table.elements();
        int i = 0;
        while (i < keys.length) {
            keys[i] = keyEnum.nextElement();
            values[i] = valueEnum.nextElement();
            ++i;
        }
        this.writeArray(writer, "keys", keys);
        this.writeArray(writer, "values", values);
    }

    public void readObject(IReader reader, Value value) throws IOException {
        Hashtable hashtable = (Hashtable)value.getObject();
        if (hashtable == null) {
            hashtable = new Hashtable();
            value.setObject(hashtable);
        }
        Object[] keys = this.readArray(reader, "keys");
        Object[] values = this.readArray(reader, "values");
        int i = 0;
        while (i < keys.length) {
            hashtable.put(keys[i], values[i]);
            ++i;
        }
    }
}

