/*
 * Decompiled with CFR 0.152.
 */
package electric.xml.io.collections.net;

import electric.util.Value;
import electric.xml.Element;
import electric.xml.io.IReader;
import electric.xml.io.IWriter;
import electric.xml.io.Type;
import electric.xml.io.collections.net.CollectionType;
import electric.xml.io.schema.SchemaException;
import java.io.IOException;
import java.util.Vector;

public class VectorType
extends CollectionType {
    public void writeSchema(Element schema) throws SchemaException {
        Type type = this.getType(CollectionType.OBJECT_ARRAY_CLASS);
        String xsdPrefix = Type.getXSDPrefix(schema);
        Element complexType = schema.addElement(xsdPrefix, "complexType");
        complexType.setAttribute("name", "Vector");
        Element sequence = complexType.addElement(xsdPrefix, "sequence");
        Element objects = sequence.addElement(xsdPrefix, "element");
        objects.setAttribute("name", "elements");
        objects.setAttribute("type", Type.getName(type.getNamespace(), type.getName(), objects));
    }

    public void writeObject(IWriter writer, Object object) throws IOException {
        Vector vector = (Vector)object;
        Object[] array = new Object[vector.size()];
        vector.copyInto(array);
        this.writeArray(writer, "elements", array);
    }

    public void readObject(IReader reader, Value value) throws IOException {
        Vector<Object> vector = (Vector<Object>)value.getObject();
        if (vector == null) {
            vector = new Vector<Object>();
            value.setObject(vector);
        }
        Object[] array = this.readArray(reader, "elements");
        int i = 0;
        while (i < array.length) {
            vector.addElement(array[i]);
            ++i;
        }
    }
}

