/*
 * Decompiled with CFR 0.152.
 */
package electric.xml.io.array;

import electric.util.Value;
import electric.xml.Element;
import electric.xml.io.IReader;
import electric.xml.io.IWriter;
import electric.xml.io.Namespaces;
import electric.xml.io.Type;
import electric.xml.io.array.ArrayType;
import electric.xml.io.schema.Schema;
import electric.xml.io.schema.SchemaException;
import java.io.IOException;
import java.lang.reflect.Array;

public class SOAP12ArrayType
extends ArrayType {
    public SOAP12ArrayType(Namespaces namespaces, Class javaClass) throws SchemaException {
        super(namespaces, javaClass);
    }

    public SOAP12ArrayType(Schema schema, String name) {
        super(schema, name);
    }

    public SOAP12ArrayType(Namespaces namespaces, String namespace, String name, String componentQName, int maxOccurs) {
        super(namespaces, namespace, name, componentQName, maxOccurs);
    }

    public void writeType(IWriter writer) throws IOException {
    }

    public void writeObject(IWriter writer, Object object) throws IOException {
        String soapPrefix = writer.getElement().getPrefix("http://www.w3.org/2003/05/soap-encoding", "soapenc");
        Type runtimeComponentType = this.getComponentType();
        String arrayType = runtimeComponentType.getName(writer.getElement());
        int arraySize = Array.getLength(object);
        writer.writeAttribute(soapPrefix, "itemType", arrayType);
        writer.writeAttribute(soapPrefix, "arraySize", "" + arraySize);
        int i = 0;
        while (i < Array.getLength(object)) {
            writer.writeObject(this.item, Array.get(object, i), this.getComponentType());
            ++i;
        }
    }

    public void readObject(IReader reader, Value value) throws IOException {
        Element arrayElement = reader.getElement();
        int arraySize = Integer.parseInt(arrayElement.getAttribute("arraySize"));
        String itemTypeName = arrayElement.getQName(arrayElement.getAttribute("itemType"));
        Namespaces namespaces = this.getNamespaces();
        Type itemType = namespaces.getTypeWithQName(itemTypeName);
        int numElements = reader.getElement().getElements().size();
        Object array = Array.newInstance(itemType.getJavaClass(), numElements);
        IReader[] children = reader.getReaders();
        int i = 0;
        while (i < children.length) {
            Array.set(array, i, children[i].readValue(itemType).getObject());
            ++i;
        }
        value.setObject(array);
    }
}

