/*
 * Decompiled with CFR 0.152.
 */
package electric.xml.io.accessors;

import electric.util.Value;
import electric.util.classloader.ClassLoaders;
import electric.util.java.JavaField;
import electric.util.java.JavaNames;
import electric.util.java.JavaSource;
import electric.util.reflect.Accessibility;
import electric.util.reflect.BeanField;
import electric.util.string.Strings;
import electric.xml.Element;
import electric.xml.io.accessors.Accessor;
import electric.xml.io.accessors.IAccessible;
import electric.xml.io.schema.SchemaException;
import java.lang.reflect.Method;
import java.util.Hashtable;

public class PropertyAccessor
extends Accessor {
    private String name;
    private Hashtable classLoaderToBeanField = new Hashtable();
    private Object NO_CLASSLOADER = new Object();

    public PropertyAccessor(IAccessible accessible, String name, BeanField field) {
        super(accessible);
        this.name = name;
        Object key = ClassLoaders.getContextClassLoader();
        if (key == null) {
            key = this.NO_CLASSLOADER;
        }
        this.classLoaderToBeanField.put(key, field);
    }

    public PropertyAccessor(IAccessible accessible, String name) {
        super(accessible);
        this.name = name;
    }

    public String toString() {
        return "PropertyAccessor( " + this.name + " )";
    }

    public void set(Value target, Value value) throws Exception {
        this.getField().set(target.object, value.object);
    }

    public Object get(Object target) throws Exception {
        return this.getField().get(target);
    }

    private synchronized BeanField getField() throws SchemaException {
        BeanField returnField;
        Object key = ClassLoaders.getContextClassLoader();
        if (key == null) {
            key = this.NO_CLASSLOADER;
        }
        if ((returnField = (BeanField)this.classLoaderToBeanField.get(key)) != null) {
            return returnField;
        }
        returnField = this.getField0();
        if (returnField != null) {
            this.classLoaderToBeanField.put(key, returnField);
        }
        return returnField;
    }

    private synchronized BeanField getField0() throws SchemaException {
        Class javaClass = this.accessible.getAccessibleJavaClass();
        BeanField field = BeanField.getBeanField(javaClass, this.name);
        if (field == null) {
            throw new SchemaException("could not find property " + this.name + " in java class " + javaClass.getName());
        }
        if (Accessibility.canSetAccessible()) {
            Accessibility.setAccessible(new Method[]{field.get, field.set}, true);
        }
        return field;
    }

    public void annotateSchema(Element element) {
        element.setAttribute("map", "property", this.name);
    }

    public void writeJava(JavaSource source) throws SchemaException {
        PropertyAccessor.writeJava(source, this.name, this.getJavaName(), this.accessible);
    }

    static void writeJava(JavaSource source, String name, String javaName, IAccessible accessible) {
        String getPrefix = "boolean".equals(javaName) ? "is" : "get";
        String mangledName = JavaNames.isJavaIdentifier(name) ? name : JavaNames.getJavaName(name);
        String capitalized = Strings.getCapitalized(name);
        source.addField(new JavaField("private", javaName, mangledName, null));
        StringBuffer buffer = new StringBuffer();
        buffer.append("  public " + javaName + " " + getPrefix + capitalized + "()\n");
        buffer.append("    {\n");
        buffer.append("    return " + mangledName + ";\n");
        buffer.append("    }");
        source.addMethod(buffer.toString());
        buffer = new StringBuffer();
        buffer.append("  public void set" + capitalized + "( " + javaName + " value )\n");
        buffer.append("    {\n");
        buffer.append("    this." + mangledName + " = value;\n");
        buffer.append("    }");
        source.addMethod(buffer.toString());
    }
}

