/*
 * Decompiled with CFR 0.152.
 */
package electric.xml.io;

import electric.util.classloader.ClassLoaders;
import electric.util.log.ILoggingConstants;
import electric.util.log.Log;
import electric.xml.IEXMLLoggingConstants;
import electric.xml.io.Mappings;
import electric.xml.io.Namespaces;
import electric.xml.io.Type;
import electric.xml.io.schema.Schema;
import electric.xml.io.schema.SchemaException;
import java.util.Enumeration;
import java.util.Hashtable;

public final class Mapping
implements IEXMLLoggingConstants {
    private String javaName;
    private String name;
    private String typeName;
    private Type type;
    private Schema schema;
    private boolean dominant;
    private String encodingStyle;
    static /* synthetic */ Class class$electric$xml$io$Type;

    public Mapping(String javaName, String namespace, String name, String typeName, boolean dominant) {
        this(javaName, namespace, name, typeName, dominant, null);
    }

    public Mapping(String javaName, String namespace, String name, String typeName, boolean dominant, String encodingStyle) {
        this.javaName = javaName;
        this.schema = new Schema(namespace);
        this.name = name;
        this.typeName = typeName;
        this.dominant = dominant;
        this.encodingStyle = encodingStyle;
    }

    public Mapping(Type type) {
        this(type, null);
    }

    public Mapping(Type type, String encodingStyle) {
        this.type = type;
        this.schema = type.getSchema();
        this.name = type.getName();
        this.dominant = type.isDominant();
        this.encodingStyle = encodingStyle;
    }

    public Type newType(Schema schema) {
        if (this.type != null) {
            Type returnType = Type.clone(this.type);
            returnType.setSchema(schema);
            return returnType;
        }
        try {
            ClassLoader classLoader = this.getClass().getClassLoader();
            Class typeClass = ClassLoaders.loadClass(this.typeName, classLoader);
            this.type = (Type)typeClass.newInstance();
            this.type.setSchema(schema);
            this.type.setName(this.name);
            this.type.setJavaName(this.javaName);
            this.type.setDominant(this.dominant);
            return this.type;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public Type newType(Namespaces namespaces) throws SchemaException {
        if (this.type != null) {
            if (!Mappings.isMappingNamespaces(namespaces)) {
                Hashtable dependencies = new Hashtable();
                this.type.addAllDependencies(dependencies);
                Enumeration enumeration = dependencies.keys();
                while (enumeration.hasMoreElements()) {
                    Type oldType = (Type)enumeration.nextElement();
                    try {
                        namespaces.getItem(oldType.getNamespace(), oldType.getName(), class$electric$xml$io$Type == null ? Mapping.class$("electric.xml.io.Type") : class$electric$xml$io$Type);
                    }
                    catch (SchemaException e) {
                        Type nextType = Type.clone(oldType);
                        nextType.setNamespaces(namespaces);
                    }
                }
            }
            Type returnType = Type.clone(this.type);
            returnType.setNamespaces(namespaces);
            return returnType;
        }
        try {
            ClassLoader classLoader = this.getClass().getClassLoader();
            Class typeClass = ClassLoaders.loadClass(this.typeName, classLoader);
            this.type = (Type)typeClass.newInstance();
            this.schema.setNamespaces(namespaces);
            this.type.setSchema(this.schema);
            this.type.setName(this.name);
            this.type.setJavaName(this.javaName);
            this.type.setDominant(this.dominant);
            return this.type;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public boolean isDominant() {
        return this.dominant;
    }

    public String getJavaName() {
        if (this.javaName != null) {
            return this.javaName;
        }
        if (this.type == null) {
            return null;
        }
        try {
            this.javaName = this.type.getJavaName();
            return this.javaName;
        }
        catch (SchemaException exception) {
            if (Log.isLogging(ILoggingConstants.EXCEPTION_EVENT)) {
                Log.log(ILoggingConstants.EXCEPTION_EVENT, "error resolving type " + this.type.getQName(), exception);
            }
            return null;
        }
    }

    public String getNamespace() {
        return this.schema.getTargetNamespace();
    }

    public String getName() {
        return this.name;
    }

    public Schema getSchema() {
        return this.schema;
    }

    public String getEncodingStyle() {
        return this.encodingStyle;
    }

    public Type getType() {
        return this.type;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

