/*
 * Decompiled with CFR 0.152.
 */
package electric.xml.config;

import electric.util.Context;
import electric.util.classloader.ClassLoaders;
import electric.util.log.ILogger;
import electric.util.log.Log;
import electric.util.product.IConfig;
import electric.util.reflect.Creator;
import electric.util.string.Strings;
import electric.xml.Element;
import electric.xml.Elements;
import electric.xml.IEXMLLoggingConstants;
import electric.xml.config.IEXMLConfigConstants;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;

public final class LoggingConfig
implements IConfig,
IEXMLConfigConstants,
IEXMLLoggingConstants {
    public void config(Element config) throws Throwable {
        String logging = Context.application().getStringProperty("electric.logging");
        if (logging != null) {
            this.configSystemProperty(logging);
        } else {
            this.configLoggingElements(config);
        }
    }

    private void configLoggingElements(Element config) throws Throwable {
        Element loggingElement = config.getElement("logging");
        if (loggingElement == null) {
            return;
        }
        Elements loggers = loggingElement.getElements("logger");
        while (loggers.hasMoreElements()) {
            Element loggerElement = loggers.next();
            this.configLoggerElement(loggerElement);
        }
        this.configExplicitCalls();
    }

    private void configExplicitCalls() {
        Hashtable explicitLogging = Log.getExplicitLogging();
        Enumeration explicitLoggingCalls = explicitLogging.keys();
        while (explicitLoggingCalls.hasMoreElements()) {
            String category = (String)explicitLoggingCalls.nextElement();
            boolean flag = (Boolean)explicitLogging.get(category);
            if (flag) {
                Log.startLogging(category);
                continue;
            }
            Log.stopLogging(category);
        }
    }

    private void configLoggerElement(Element loggerElement) throws Throwable {
        Elements logCategories = loggerElement.getElements("log");
        String name = loggerElement.getTrimTextString("name");
        ILogger logger = (ILogger)Creator.newInstance(loggerElement, ClassLoaders.getContextClassLoader());
        Log.addLogger(name, logger);
        while (logCategories.hasMoreElements()) {
            Element logCategory = logCategories.next();
            String enabled = logCategory.getAttribute("enabled");
            String category = logCategory.getString();
            if (enabled == null || Strings.getBoolean(enabled, true)) {
                logger.startLogging(category);
                continue;
            }
            if (Log.isLogging(category)) continue;
            logger.stopLogging(category);
        }
    }

    private void configSystemProperty(String logging) {
        StringTokenizer tokenizer = new StringTokenizer(logging, ", \t");
        while (tokenizer.hasMoreTokens()) {
            Log.startLogging(tokenizer.nextToken());
        }
    }
}

